/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatSearchQuery {
    private final String text;
    private final String generationId;
    private final Map<String, Object> additionalProperties;

    private ChatSearchQuery(String text, String generationId, Map<String, Object> additionalProperties) {
        this.text = text;
        this.generationId = generationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="generation_id")
    public String getGenerationId() {
        return this.generationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatSearchQuery && this.equalTo((ChatSearchQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatSearchQuery other) {
        return this.text.equals(other.text) && this.generationId.equals(other.generationId);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.generationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    GenerationIdStage,
    _FinalStage {
        private String text;
        private String generationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatSearchQuery other) {
            this.text(other.getText());
            this.generationId(other.getGenerationId());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public GenerationIdStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="generation_id")
        public _FinalStage generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        @Override
        public ChatSearchQuery build() {
            return new ChatSearchQuery(this.text, this.generationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatSearchQuery build();
    }

    public static interface GenerationIdStage {
        public _FinalStage generationId(String var1);
    }

    public static interface TextStage {
        public GenerationIdStage text(String var1);

        public Builder from(ChatSearchQuery var1);
    }
}

