/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.IChatStreamEvent;
import com.cohere.api.types.ToolCallDelta;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatToolCallsChunkEvent
implements IChatStreamEvent {
    private final ToolCallDelta toolCallDelta;
    private final Optional<String> text;
    private final Map<String, Object> additionalProperties;

    private ChatToolCallsChunkEvent(ToolCallDelta toolCallDelta, Optional<String> text, Map<String, Object> additionalProperties) {
        this.toolCallDelta = toolCallDelta;
        this.text = text;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tool_call_delta")
    public ToolCallDelta getToolCallDelta() {
        return this.toolCallDelta;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatToolCallsChunkEvent && this.equalTo((ChatToolCallsChunkEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatToolCallsChunkEvent other) {
        return this.toolCallDelta.equals(other.toolCallDelta) && this.text.equals(other.text);
    }

    public int hashCode() {
        return Objects.hash(this.toolCallDelta, this.text);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ToolCallDeltaStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ToolCallDeltaStage,
    _FinalStage {
        private ToolCallDelta toolCallDelta;
        private Optional<String> text = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatToolCallsChunkEvent other) {
            this.toolCallDelta(other.getToolCallDelta());
            this.text(other.getText());
            return this;
        }

        @Override
        @JsonSetter(value="tool_call_delta")
        public _FinalStage toolCallDelta(ToolCallDelta toolCallDelta) {
            this.toolCallDelta = toolCallDelta;
            return this;
        }

        @Override
        public _FinalStage text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @Override
        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public _FinalStage text(Optional<String> text) {
            this.text = text;
            return this;
        }

        @Override
        public ChatToolCallsChunkEvent build() {
            return new ChatToolCallsChunkEvent(this.toolCallDelta, this.text, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatToolCallsChunkEvent build();

        public _FinalStage text(Optional<String> var1);

        public _FinalStage text(String var1);
    }

    public static interface ToolCallDeltaStage {
        public _FinalStage toolCallDelta(ToolCallDelta var1);

        public Builder from(ChatToolCallsChunkEvent var1);
    }
}

