/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.IChatStreamEvent;
import com.cohere.api.types.ToolCall;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatToolCallsGenerationEvent
implements IChatStreamEvent {
    private final Optional<String> text;
    private final List<ToolCall> toolCalls;
    private final Map<String, Object> additionalProperties;

    private ChatToolCallsGenerationEvent(Optional<String> text, List<ToolCall> toolCalls, Map<String, Object> additionalProperties) {
        this.text = text;
        this.toolCalls = toolCalls;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    @JsonProperty(value="tool_calls")
    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatToolCallsGenerationEvent && this.equalTo((ChatToolCallsGenerationEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatToolCallsGenerationEvent other) {
        return this.text.equals(other.text) && this.toolCalls.equals(other.toolCalls);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.toolCalls);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> text = Optional.empty();
        private List<ToolCall> toolCalls = new ArrayList<ToolCall>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatToolCallsGenerationEvent other) {
            this.text(other.getText());
            this.toolCalls(other.getToolCalls());
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<String> text) {
            this.text = text;
            return this;
        }

        public Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @JsonSetter(value="tool_calls", nulls=Nulls.SKIP)
        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls.clear();
            this.toolCalls.addAll(toolCalls);
            return this;
        }

        public Builder addToolCalls(ToolCall toolCalls) {
            this.toolCalls.add(toolCalls);
            return this;
        }

        public Builder addAllToolCalls(List<ToolCall> toolCalls) {
            this.toolCalls.addAll(toolCalls);
            return this;
        }

        public ChatToolCallsGenerationEvent build() {
            return new ChatToolCallsGenerationEvent(this.text, this.toolCalls, this.additionalProperties);
        }
    }
}

