/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CheckApiKeyResponse {
    private final boolean valid;
    private final Optional<String> organizationId;
    private final Optional<String> ownerId;
    private final Map<String, Object> additionalProperties;

    private CheckApiKeyResponse(boolean valid, Optional<String> organizationId, Optional<String> ownerId, Map<String, Object> additionalProperties) {
        this.valid = valid;
        this.organizationId = organizationId;
        this.ownerId = ownerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="valid")
    public boolean getValid() {
        return this.valid;
    }

    @JsonProperty(value="organization_id")
    public Optional<String> getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="owner_id")
    public Optional<String> getOwnerId() {
        return this.ownerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckApiKeyResponse && this.equalTo((CheckApiKeyResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckApiKeyResponse other) {
        return this.valid == other.valid && this.organizationId.equals(other.organizationId) && this.ownerId.equals(other.ownerId);
    }

    public int hashCode() {
        return Objects.hash(this.valid, this.organizationId, this.ownerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ValidStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ValidStage,
    _FinalStage {
        private boolean valid;
        private Optional<String> ownerId = Optional.empty();
        private Optional<String> organizationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CheckApiKeyResponse other) {
            this.valid(other.getValid());
            this.organizationId(other.getOrganizationId());
            this.ownerId(other.getOwnerId());
            return this;
        }

        @Override
        @JsonSetter(value="valid")
        public _FinalStage valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public _FinalStage ownerId(String ownerId) {
            this.ownerId = Optional.of(ownerId);
            return this;
        }

        @Override
        @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
        public _FinalStage ownerId(Optional<String> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Override
        public _FinalStage organizationId(String organizationId) {
            this.organizationId = Optional.of(organizationId);
            return this;
        }

        @Override
        @JsonSetter(value="organization_id", nulls=Nulls.SKIP)
        public _FinalStage organizationId(Optional<String> organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Override
        public CheckApiKeyResponse build() {
            return new CheckApiKeyResponse(this.valid, this.organizationId, this.ownerId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CheckApiKeyResponse build();

        public _FinalStage organizationId(Optional<String> var1);

        public _FinalStage organizationId(String var1);

        public _FinalStage ownerId(Optional<String> var1);

        public _FinalStage ownerId(String var1);
    }

    public static interface ValidStage {
        public _FinalStage valid(boolean var1);

        public Builder from(CheckApiKeyResponse var1);
    }
}

