/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.Source;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Citation {
    private final Optional<Integer> start;
    private final Optional<Integer> end;
    private final Optional<String> text;
    private final Optional<List<Source>> sources;
    private final Map<String, Object> additionalProperties;

    private Citation(Optional<Integer> start, Optional<Integer> end, Optional<String> text, Optional<List<Source>> sources, Map<String, Object> additionalProperties) {
        this.start = start;
        this.end = end;
        this.text = text;
        this.sources = sources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="start")
    public Optional<Integer> getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public Optional<Integer> getEnd() {
        return this.end;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    @JsonProperty(value="sources")
    public Optional<List<Source>> getSources() {
        return this.sources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Citation && this.equalTo((Citation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Citation other) {
        return this.start.equals(other.start) && this.end.equals(other.end) && this.text.equals(other.text) && this.sources.equals(other.sources);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.text, this.sources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> start = Optional.empty();
        private Optional<Integer> end = Optional.empty();
        private Optional<String> text = Optional.empty();
        private Optional<List<Source>> sources = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Citation other) {
            this.start(other.getStart());
            this.end(other.getEnd());
            this.text(other.getText());
            this.sources(other.getSources());
            return this;
        }

        @JsonSetter(value="start", nulls=Nulls.SKIP)
        public Builder start(Optional<Integer> start) {
            this.start = start;
            return this;
        }

        public Builder start(Integer start) {
            this.start = Optional.of(start);
            return this;
        }

        @JsonSetter(value="end", nulls=Nulls.SKIP)
        public Builder end(Optional<Integer> end) {
            this.end = end;
            return this;
        }

        public Builder end(Integer end) {
            this.end = Optional.of(end);
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<String> text) {
            this.text = text;
            return this;
        }

        public Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @JsonSetter(value="sources", nulls=Nulls.SKIP)
        public Builder sources(Optional<List<Source>> sources) {
            this.sources = sources;
            return this;
        }

        public Builder sources(List<Source> sources) {
            this.sources = Optional.of(sources);
            return this;
        }

        public Citation build() {
            return new Citation(this.start, this.end, this.text, this.sources, this.additionalProperties);
        }
    }
}

