/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CitationOptionsMode;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CitationOptions {
    private final Optional<CitationOptionsMode> mode;
    private final Map<String, Object> additionalProperties;

    private CitationOptions(Optional<CitationOptionsMode> mode, Map<String, Object> additionalProperties) {
        this.mode = mode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="mode")
    public Optional<CitationOptionsMode> getMode() {
        return this.mode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CitationOptions && this.equalTo((CitationOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CitationOptions other) {
        return this.mode.equals(other.mode);
    }

    public int hashCode() {
        return Objects.hash(this.mode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CitationOptionsMode> mode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CitationOptions other) {
            this.mode(other.getMode());
            return this;
        }

        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(Optional<CitationOptionsMode> mode) {
            this.mode = mode;
            return this;
        }

        public Builder mode(CitationOptionsMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        public CitationOptions build() {
            return new CitationOptions(this.mode, this.additionalProperties);
        }
    }
}

