/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ClassifyResponseClassificationsItemClassificationType;
import com.cohere.api.types.ClassifyResponseClassificationsItemLabelsValue;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyResponseClassificationsItem {
    private final String id;
    private final Optional<String> input;
    private final Optional<String> prediction;
    private final List<String> predictions;
    private final Optional<Double> confidence;
    private final List<Double> confidences;
    private final Map<String, ClassifyResponseClassificationsItemLabelsValue> labels;
    private final ClassifyResponseClassificationsItemClassificationType classificationType;
    private final Map<String, Object> additionalProperties;

    private ClassifyResponseClassificationsItem(String id, Optional<String> input, Optional<String> prediction, List<String> predictions, Optional<Double> confidence, List<Double> confidences, Map<String, ClassifyResponseClassificationsItemLabelsValue> labels, ClassifyResponseClassificationsItemClassificationType classificationType, Map<String, Object> additionalProperties) {
        this.id = id;
        this.input = input;
        this.prediction = prediction;
        this.predictions = predictions;
        this.confidence = confidence;
        this.confidences = confidences;
        this.labels = labels;
        this.classificationType = classificationType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="input")
    public Optional<String> getInput() {
        return this.input;
    }

    @JsonProperty(value="prediction")
    public Optional<String> getPrediction() {
        return this.prediction;
    }

    @JsonProperty(value="predictions")
    public List<String> getPredictions() {
        return this.predictions;
    }

    @JsonProperty(value="confidence")
    public Optional<Double> getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidences")
    public List<Double> getConfidences() {
        return this.confidences;
    }

    @JsonProperty(value="labels")
    public Map<String, ClassifyResponseClassificationsItemLabelsValue> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="classification_type")
    public ClassifyResponseClassificationsItemClassificationType getClassificationType() {
        return this.classificationType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyResponseClassificationsItem && this.equalTo((ClassifyResponseClassificationsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClassifyResponseClassificationsItem other) {
        return this.id.equals(other.id) && this.input.equals(other.input) && this.prediction.equals(other.prediction) && this.predictions.equals(other.predictions) && this.confidence.equals(other.confidence) && this.confidences.equals(other.confidences) && this.labels.equals(other.labels) && this.classificationType.equals((Object)other.classificationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.input, this.prediction, this.predictions, this.confidence, this.confidences, this.labels, this.classificationType});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ClassificationTypeStage,
    _FinalStage {
        private String id;
        private ClassifyResponseClassificationsItemClassificationType classificationType;
        private Map<String, ClassifyResponseClassificationsItemLabelsValue> labels = new LinkedHashMap<String, ClassifyResponseClassificationsItemLabelsValue>();
        private List<Double> confidences = new ArrayList<Double>();
        private Optional<Double> confidence = Optional.empty();
        private List<String> predictions = new ArrayList<String>();
        private Optional<String> prediction = Optional.empty();
        private Optional<String> input = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ClassifyResponseClassificationsItem other) {
            this.id(other.getId());
            this.input(other.getInput());
            this.prediction(other.getPrediction());
            this.predictions(other.getPredictions());
            this.confidence(other.getConfidence());
            this.confidences(other.getConfidences());
            this.labels(other.getLabels());
            this.classificationType(other.getClassificationType());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ClassificationTypeStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="classification_type")
        public _FinalStage classificationType(ClassifyResponseClassificationsItemClassificationType classificationType) {
            this.classificationType = classificationType;
            return this;
        }

        @Override
        public _FinalStage labels(String key, ClassifyResponseClassificationsItemLabelsValue value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.putAll(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.clear();
            this.labels.putAll(labels);
            return this;
        }

        @Override
        public _FinalStage addAllConfidences(List<Double> confidences) {
            this.confidences.addAll(confidences);
            return this;
        }

        @Override
        public _FinalStage addConfidences(Double confidences) {
            this.confidences.add(confidences);
            return this;
        }

        @Override
        @JsonSetter(value="confidences", nulls=Nulls.SKIP)
        public _FinalStage confidences(List<Double> confidences) {
            this.confidences.clear();
            this.confidences.addAll(confidences);
            return this;
        }

        @Override
        public _FinalStage confidence(Double confidence) {
            this.confidence = Optional.of(confidence);
            return this;
        }

        @Override
        @JsonSetter(value="confidence", nulls=Nulls.SKIP)
        public _FinalStage confidence(Optional<Double> confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage addAllPredictions(List<String> predictions) {
            this.predictions.addAll(predictions);
            return this;
        }

        @Override
        public _FinalStage addPredictions(String predictions) {
            this.predictions.add(predictions);
            return this;
        }

        @Override
        @JsonSetter(value="predictions", nulls=Nulls.SKIP)
        public _FinalStage predictions(List<String> predictions) {
            this.predictions.clear();
            this.predictions.addAll(predictions);
            return this;
        }

        @Override
        public _FinalStage prediction(String prediction) {
            this.prediction = Optional.of(prediction);
            return this;
        }

        @Override
        @JsonSetter(value="prediction", nulls=Nulls.SKIP)
        public _FinalStage prediction(Optional<String> prediction) {
            this.prediction = prediction;
            return this;
        }

        @Override
        public _FinalStage input(String input) {
            this.input = Optional.of(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<String> input) {
            this.input = input;
            return this;
        }

        @Override
        public ClassifyResponseClassificationsItem build() {
            return new ClassifyResponseClassificationsItem(this.id, this.input, this.prediction, this.predictions, this.confidence, this.confidences, this.labels, this.classificationType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ClassifyResponseClassificationsItem build();

        public _FinalStage input(Optional<String> var1);

        public _FinalStage input(String var1);

        public _FinalStage prediction(Optional<String> var1);

        public _FinalStage prediction(String var1);

        public _FinalStage predictions(List<String> var1);

        public _FinalStage addPredictions(String var1);

        public _FinalStage addAllPredictions(List<String> var1);

        public _FinalStage confidence(Optional<Double> var1);

        public _FinalStage confidence(Double var1);

        public _FinalStage confidences(List<Double> var1);

        public _FinalStage addConfidences(Double var1);

        public _FinalStage addAllConfidences(List<Double> var1);

        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage labels(String var1, ClassifyResponseClassificationsItemLabelsValue var2);
    }

    public static interface ClassificationTypeStage {
        public _FinalStage classificationType(ClassifyResponseClassificationsItemClassificationType var1);
    }

    public static interface IdStage {
        public ClassificationTypeStage id(String var1);

        public Builder from(ClassifyResponseClassificationsItem var1);
    }
}

