/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ConnectorAuthStatus;
import com.cohere.api.types.ConnectorOAuth;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Connector {
    private final String id;
    private final Optional<String> organizationId;
    private final String name;
    private final Optional<String> description;
    private final Optional<String> url;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Optional<List<String>> excludes;
    private final Optional<String> authType;
    private final Optional<ConnectorOAuth> oauth;
    private final Optional<ConnectorAuthStatus> authStatus;
    private final Optional<Boolean> active;
    private final Optional<Boolean> continueOnFailure;
    private final Map<String, Object> additionalProperties;

    private Connector(String id, Optional<String> organizationId, String name, Optional<String> description, Optional<String> url, OffsetDateTime createdAt, OffsetDateTime updatedAt, Optional<List<String>> excludes, Optional<String> authType, Optional<ConnectorOAuth> oauth, Optional<ConnectorAuthStatus> authStatus, Optional<Boolean> active, Optional<Boolean> continueOnFailure, Map<String, Object> additionalProperties) {
        this.id = id;
        this.organizationId = organizationId;
        this.name = name;
        this.description = description;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.excludes = excludes;
        this.authType = authType;
        this.oauth = oauth;
        this.authStatus = authStatus;
        this.active = active;
        this.continueOnFailure = continueOnFailure;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="organization_id")
    public Optional<String> getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="excludes")
    public Optional<List<String>> getExcludes() {
        return this.excludes;
    }

    @JsonProperty(value="auth_type")
    public Optional<String> getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="oauth")
    public Optional<ConnectorOAuth> getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="auth_status")
    public Optional<ConnectorAuthStatus> getAuthStatus() {
        return this.authStatus;
    }

    @JsonProperty(value="active")
    public Optional<Boolean> getActive() {
        return this.active;
    }

    @JsonProperty(value="continue_on_failure")
    public Optional<Boolean> getContinueOnFailure() {
        return this.continueOnFailure;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Connector && this.equalTo((Connector)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Connector other) {
        return this.id.equals(other.id) && this.organizationId.equals(other.organizationId) && this.name.equals(other.name) && this.description.equals(other.description) && this.url.equals(other.url) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.excludes.equals(other.excludes) && this.authType.equals(other.authType) && this.oauth.equals(other.oauth) && this.authStatus.equals(other.authStatus) && this.active.equals(other.active) && this.continueOnFailure.equals(other.continueOnFailure);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organizationId, this.name, this.description, this.url, this.createdAt, this.updatedAt, this.excludes, this.authType, this.oauth, this.authStatus, this.active, this.continueOnFailure);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String name;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<Boolean> continueOnFailure = Optional.empty();
        private Optional<Boolean> active = Optional.empty();
        private Optional<ConnectorAuthStatus> authStatus = Optional.empty();
        private Optional<ConnectorOAuth> oauth = Optional.empty();
        private Optional<String> authType = Optional.empty();
        private Optional<List<String>> excludes = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> organizationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Connector other) {
            this.id(other.getId());
            this.organizationId(other.getOrganizationId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.url(other.getUrl());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.excludes(other.getExcludes());
            this.authType(other.getAuthType());
            this.oauth(other.getOauth());
            this.authStatus(other.getAuthStatus());
            this.active(other.getActive());
            this.continueOnFailure(other.getContinueOnFailure());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage continueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = Optional.of(continueOnFailure);
            return this;
        }

        @Override
        @JsonSetter(value="continue_on_failure", nulls=Nulls.SKIP)
        public _FinalStage continueOnFailure(Optional<Boolean> continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        @Override
        public _FinalStage active(Boolean active) {
            this.active = Optional.of(active);
            return this;
        }

        @Override
        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public _FinalStage active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        @Override
        public _FinalStage authStatus(ConnectorAuthStatus authStatus) {
            this.authStatus = Optional.of(authStatus);
            return this;
        }

        @Override
        @JsonSetter(value="auth_status", nulls=Nulls.SKIP)
        public _FinalStage authStatus(Optional<ConnectorAuthStatus> authStatus) {
            this.authStatus = authStatus;
            return this;
        }

        @Override
        public _FinalStage oauth(ConnectorOAuth oauth) {
            this.oauth = Optional.of(oauth);
            return this;
        }

        @Override
        @JsonSetter(value="oauth", nulls=Nulls.SKIP)
        public _FinalStage oauth(Optional<ConnectorOAuth> oauth) {
            this.oauth = oauth;
            return this;
        }

        @Override
        public _FinalStage authType(String authType) {
            this.authType = Optional.of(authType);
            return this;
        }

        @Override
        @JsonSetter(value="auth_type", nulls=Nulls.SKIP)
        public _FinalStage authType(Optional<String> authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public _FinalStage excludes(List<String> excludes) {
            this.excludes = Optional.of(excludes);
            return this;
        }

        @Override
        @JsonSetter(value="excludes", nulls=Nulls.SKIP)
        public _FinalStage excludes(Optional<List<String>> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.of(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage organizationId(String organizationId) {
            this.organizationId = Optional.of(organizationId);
            return this;
        }

        @Override
        @JsonSetter(value="organization_id", nulls=Nulls.SKIP)
        public _FinalStage organizationId(Optional<String> organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Override
        public Connector build() {
            return new Connector(this.id, this.organizationId, this.name, this.description, this.url, this.createdAt, this.updatedAt, this.excludes, this.authType, this.oauth, this.authStatus, this.active, this.continueOnFailure, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Connector build();

        public _FinalStage organizationId(Optional<String> var1);

        public _FinalStage organizationId(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage excludes(Optional<List<String>> var1);

        public _FinalStage excludes(List<String> var1);

        public _FinalStage authType(Optional<String> var1);

        public _FinalStage authType(String var1);

        public _FinalStage oauth(Optional<ConnectorOAuth> var1);

        public _FinalStage oauth(ConnectorOAuth var1);

        public _FinalStage authStatus(Optional<ConnectorAuthStatus> var1);

        public _FinalStage authStatus(ConnectorAuthStatus var1);

        public _FinalStage active(Optional<Boolean> var1);

        public _FinalStage active(Boolean var1);

        public _FinalStage continueOnFailure(Optional<Boolean> var1);

        public _FinalStage continueOnFailure(Boolean var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(OffsetDateTime var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(String var1);
    }

    public static interface IdStage {
        public NameStage id(String var1);

        public Builder from(Connector var1);
    }
}

