/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.DatasetPart;
import com.cohere.api.types.DatasetType;
import com.cohere.api.types.DatasetValidationStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Dataset {
    private final String id;
    private final String name;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final DatasetType datasetType;
    private final DatasetValidationStatus validationStatus;
    private final Optional<String> validationError;
    private final Optional<String> schema;
    private final Optional<List<String>> requiredFields;
    private final Optional<List<String>> preserveFields;
    private final Optional<List<DatasetPart>> datasetParts;
    private final Optional<List<String>> validationWarnings;
    private final Map<String, Object> additionalProperties;

    private Dataset(String id, String name, OffsetDateTime createdAt, OffsetDateTime updatedAt, DatasetType datasetType, DatasetValidationStatus validationStatus, Optional<String> validationError, Optional<String> schema, Optional<List<String>> requiredFields, Optional<List<String>> preserveFields, Optional<List<DatasetPart>> datasetParts, Optional<List<String>> validationWarnings, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.datasetType = datasetType;
        this.validationStatus = validationStatus;
        this.validationError = validationError;
        this.schema = schema;
        this.requiredFields = requiredFields;
        this.preserveFields = preserveFields;
        this.datasetParts = datasetParts;
        this.validationWarnings = validationWarnings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="dataset_type")
    public DatasetType getDatasetType() {
        return this.datasetType;
    }

    @JsonProperty(value="validation_status")
    public DatasetValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    @JsonProperty(value="validation_error")
    public Optional<String> getValidationError() {
        return this.validationError;
    }

    @JsonProperty(value="schema")
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="required_fields")
    public Optional<List<String>> getRequiredFields() {
        return this.requiredFields;
    }

    @JsonProperty(value="preserve_fields")
    public Optional<List<String>> getPreserveFields() {
        return this.preserveFields;
    }

    @JsonProperty(value="dataset_parts")
    public Optional<List<DatasetPart>> getDatasetParts() {
        return this.datasetParts;
    }

    @JsonProperty(value="validation_warnings")
    public Optional<List<String>> getValidationWarnings() {
        return this.validationWarnings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Dataset && this.equalTo((Dataset)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Dataset other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.datasetType.equals((Object)other.datasetType) && this.validationStatus.equals((Object)other.validationStatus) && this.validationError.equals(other.validationError) && this.schema.equals(other.schema) && this.requiredFields.equals(other.requiredFields) && this.preserveFields.equals(other.preserveFields) && this.datasetParts.equals(other.datasetParts) && this.validationWarnings.equals(other.validationWarnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.createdAt, this.updatedAt, this.datasetType, this.validationStatus, this.validationError, this.schema, this.requiredFields, this.preserveFields, this.datasetParts, this.validationWarnings});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CreatedAtStage,
    UpdatedAtStage,
    DatasetTypeStage,
    ValidationStatusStage,
    _FinalStage {
        private String id;
        private String name;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private DatasetType datasetType;
        private DatasetValidationStatus validationStatus;
        private Optional<List<String>> validationWarnings = Optional.empty();
        private Optional<List<DatasetPart>> datasetParts = Optional.empty();
        private Optional<List<String>> preserveFields = Optional.empty();
        private Optional<List<String>> requiredFields = Optional.empty();
        private Optional<String> schema = Optional.empty();
        private Optional<String> validationError = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Dataset other) {
            this.id(other.getId());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.datasetType(other.getDatasetType());
            this.validationStatus(other.getValidationStatus());
            this.validationError(other.getValidationError());
            this.schema(other.getSchema());
            this.requiredFields(other.getRequiredFields());
            this.preserveFields(other.getPreserveFields());
            this.datasetParts(other.getDatasetParts());
            this.validationWarnings(other.getValidationWarnings());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public DatasetTypeStage updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="dataset_type")
        public ValidationStatusStage datasetType(DatasetType datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        @JsonSetter(value="validation_status")
        public _FinalStage validationStatus(DatasetValidationStatus validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public _FinalStage validationWarnings(List<String> validationWarnings) {
            this.validationWarnings = Optional.of(validationWarnings);
            return this;
        }

        @Override
        @JsonSetter(value="validation_warnings", nulls=Nulls.SKIP)
        public _FinalStage validationWarnings(Optional<List<String>> validationWarnings) {
            this.validationWarnings = validationWarnings;
            return this;
        }

        @Override
        public _FinalStage datasetParts(List<DatasetPart> datasetParts) {
            this.datasetParts = Optional.of(datasetParts);
            return this;
        }

        @Override
        @JsonSetter(value="dataset_parts", nulls=Nulls.SKIP)
        public _FinalStage datasetParts(Optional<List<DatasetPart>> datasetParts) {
            this.datasetParts = datasetParts;
            return this;
        }

        @Override
        public _FinalStage preserveFields(List<String> preserveFields) {
            this.preserveFields = Optional.of(preserveFields);
            return this;
        }

        @Override
        @JsonSetter(value="preserve_fields", nulls=Nulls.SKIP)
        public _FinalStage preserveFields(Optional<List<String>> preserveFields) {
            this.preserveFields = preserveFields;
            return this;
        }

        @Override
        public _FinalStage requiredFields(List<String> requiredFields) {
            this.requiredFields = Optional.of(requiredFields);
            return this;
        }

        @Override
        @JsonSetter(value="required_fields", nulls=Nulls.SKIP)
        public _FinalStage requiredFields(Optional<List<String>> requiredFields) {
            this.requiredFields = requiredFields;
            return this;
        }

        @Override
        public _FinalStage schema(String schema) {
            this.schema = Optional.of(schema);
            return this;
        }

        @Override
        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public _FinalStage schema(Optional<String> schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public _FinalStage validationError(String validationError) {
            this.validationError = Optional.of(validationError);
            return this;
        }

        @Override
        @JsonSetter(value="validation_error", nulls=Nulls.SKIP)
        public _FinalStage validationError(Optional<String> validationError) {
            this.validationError = validationError;
            return this;
        }

        @Override
        public Dataset build() {
            return new Dataset(this.id, this.name, this.createdAt, this.updatedAt, this.datasetType, this.validationStatus, this.validationError, this.schema, this.requiredFields, this.preserveFields, this.datasetParts, this.validationWarnings, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Dataset build();

        public _FinalStage validationError(Optional<String> var1);

        public _FinalStage validationError(String var1);

        public _FinalStage schema(Optional<String> var1);

        public _FinalStage schema(String var1);

        public _FinalStage requiredFields(Optional<List<String>> var1);

        public _FinalStage requiredFields(List<String> var1);

        public _FinalStage preserveFields(Optional<List<String>> var1);

        public _FinalStage preserveFields(List<String> var1);

        public _FinalStage datasetParts(Optional<List<DatasetPart>> var1);

        public _FinalStage datasetParts(List<DatasetPart> var1);

        public _FinalStage validationWarnings(Optional<List<String>> var1);

        public _FinalStage validationWarnings(List<String> var1);
    }

    public static interface ValidationStatusStage {
        public _FinalStage validationStatus(DatasetValidationStatus var1);
    }

    public static interface DatasetTypeStage {
        public ValidationStatusStage datasetType(DatasetType var1);
    }

    public static interface UpdatedAtStage {
        public DatasetTypeStage updatedAt(OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(OffsetDateTime var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(String var1);
    }

    public static interface IdStage {
        public NameStage id(String var1);

        public Builder from(Dataset var1);
    }
}

