/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.EmbedByTypeResponseEmbeddings;
import com.cohere.api.types.Image;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class EmbedByTypeResponse {
    private final String id;
    private final EmbedByTypeResponseEmbeddings embeddings;
    private final List<String> texts;
    private final Optional<List<Image>> images;
    private final Optional<ApiMeta> meta;
    private final Map<String, Object> additionalProperties;

    private EmbedByTypeResponse(String id, EmbedByTypeResponseEmbeddings embeddings, List<String> texts, Optional<List<Image>> images, Optional<ApiMeta> meta, Map<String, Object> additionalProperties) {
        this.id = id;
        this.embeddings = embeddings;
        this.texts = texts;
        this.images = images;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="embeddings")
    public EmbedByTypeResponseEmbeddings getEmbeddings() {
        return this.embeddings;
    }

    @JsonProperty(value="texts")
    public List<String> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="images")
    public Optional<List<Image>> getImages() {
        return this.images;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedByTypeResponse && this.equalTo((EmbedByTypeResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmbedByTypeResponse other) {
        return this.id.equals(other.id) && this.embeddings.equals(other.embeddings) && this.texts.equals(other.texts) && this.images.equals(other.images) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.embeddings, this.texts, this.images, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    EmbeddingsStage,
    _FinalStage {
        private String id;
        private EmbedByTypeResponseEmbeddings embeddings;
        private Optional<ApiMeta> meta = Optional.empty();
        private Optional<List<Image>> images = Optional.empty();
        private List<String> texts = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EmbedByTypeResponse other) {
            this.id(other.getId());
            this.embeddings(other.getEmbeddings());
            this.texts(other.getTexts());
            this.images(other.getImages());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public EmbeddingsStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="embeddings")
        public _FinalStage embeddings(EmbedByTypeResponseEmbeddings embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.of(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage images(List<Image> images) {
            this.images = Optional.of(images);
            return this;
        }

        @Override
        @JsonSetter(value="images", nulls=Nulls.SKIP)
        public _FinalStage images(Optional<List<Image>> images) {
            this.images = images;
            return this;
        }

        @Override
        public _FinalStage addAllTexts(List<String> texts) {
            this.texts.addAll(texts);
            return this;
        }

        @Override
        public _FinalStage addTexts(String texts) {
            this.texts.add(texts);
            return this;
        }

        @Override
        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public _FinalStage texts(List<String> texts) {
            this.texts.clear();
            this.texts.addAll(texts);
            return this;
        }

        @Override
        public EmbedByTypeResponse build() {
            return new EmbedByTypeResponse(this.id, this.embeddings, this.texts, this.images, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EmbedByTypeResponse build();

        public _FinalStage texts(List<String> var1);

        public _FinalStage addTexts(String var1);

        public _FinalStage addAllTexts(List<String> var1);

        public _FinalStage images(Optional<List<Image>> var1);

        public _FinalStage images(List<Image> var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface EmbeddingsStage {
        public _FinalStage embeddings(EmbedByTypeResponseEmbeddings var1);
    }

    public static interface IdStage {
        public EmbeddingsStage id(String var1);

        public Builder from(EmbedByTypeResponse var1);
    }
}

