/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.EmbedByTypeResponse;
import com.cohere.api.types.EmbedFloatsResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class EmbedResponse {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private EmbedResponse(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static EmbedResponse embeddingsFloats(EmbedFloatsResponse value) {
        return new EmbedResponse(new EmbeddingsFloatsValue(value));
    }

    public static EmbedResponse embeddingsByType(EmbedByTypeResponse value) {
        return new EmbedResponse(new EmbeddingsByTypeValue(value));
    }

    public boolean isEmbeddingsFloats() {
        return this.value instanceof EmbeddingsFloatsValue;
    }

    public boolean isEmbeddingsByType() {
        return this.value instanceof EmbeddingsByTypeValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<EmbedFloatsResponse> getEmbeddingsFloats() {
        if (this.isEmbeddingsFloats()) {
            return Optional.of(((EmbeddingsFloatsValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<EmbedByTypeResponse> getEmbeddingsByType() {
        if (this.isEmbeddingsByType()) {
            return Optional.of(((EmbeddingsByTypeValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "EmbedResponse{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="embeddings_by_type")
    private static final class EmbeddingsByTypeValue
    implements Value {
        @JsonUnwrapped
        private EmbedByTypeResponse value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EmbeddingsByTypeValue() {
        }

        private EmbeddingsByTypeValue(EmbedByTypeResponse value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitEmbeddingsByType(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EmbeddingsByTypeValue && this.equalTo((EmbeddingsByTypeValue)other);
        }

        private boolean equalTo(EmbeddingsByTypeValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "EmbedResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="embeddings_floats")
    private static final class EmbeddingsFloatsValue
    implements Value {
        @JsonUnwrapped
        private EmbedFloatsResponse value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EmbeddingsFloatsValue() {
        }

        private EmbeddingsFloatsValue(EmbedFloatsResponse value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitEmbeddingsFloats(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EmbeddingsFloatsValue && this.equalTo((EmbeddingsFloatsValue)other);
        }

        private boolean equalTo(EmbeddingsFloatsValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "EmbedResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response_type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=EmbeddingsFloatsValue.class), @JsonSubTypes.Type(value=EmbeddingsByTypeValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitEmbeddingsFloats(EmbedFloatsResponse var1);

        public T visitEmbeddingsByType(EmbedByTypeResponse var1);

        public T _visitUnknown(Object var1);
    }
}

