/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class FinetuneDatasetMetrics {
    private final Optional<Long> trainableTokenCount;
    private final Optional<Long> totalExamples;
    private final Optional<Long> trainExamples;
    private final Optional<Long> trainSizeBytes;
    private final Optional<Long> evalExamples;
    private final Optional<Long> evalSizeBytes;
    private final Map<String, Object> additionalProperties;

    private FinetuneDatasetMetrics(Optional<Long> trainableTokenCount, Optional<Long> totalExamples, Optional<Long> trainExamples, Optional<Long> trainSizeBytes, Optional<Long> evalExamples, Optional<Long> evalSizeBytes, Map<String, Object> additionalProperties) {
        this.trainableTokenCount = trainableTokenCount;
        this.totalExamples = totalExamples;
        this.trainExamples = trainExamples;
        this.trainSizeBytes = trainSizeBytes;
        this.evalExamples = evalExamples;
        this.evalSizeBytes = evalSizeBytes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="trainable_token_count")
    public Optional<Long> getTrainableTokenCount() {
        return this.trainableTokenCount;
    }

    @JsonProperty(value="total_examples")
    public Optional<Long> getTotalExamples() {
        return this.totalExamples;
    }

    @JsonProperty(value="train_examples")
    public Optional<Long> getTrainExamples() {
        return this.trainExamples;
    }

    @JsonProperty(value="train_size_bytes")
    public Optional<Long> getTrainSizeBytes() {
        return this.trainSizeBytes;
    }

    @JsonProperty(value="eval_examples")
    public Optional<Long> getEvalExamples() {
        return this.evalExamples;
    }

    @JsonProperty(value="eval_size_bytes")
    public Optional<Long> getEvalSizeBytes() {
        return this.evalSizeBytes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FinetuneDatasetMetrics && this.equalTo((FinetuneDatasetMetrics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FinetuneDatasetMetrics other) {
        return this.trainableTokenCount.equals(other.trainableTokenCount) && this.totalExamples.equals(other.totalExamples) && this.trainExamples.equals(other.trainExamples) && this.trainSizeBytes.equals(other.trainSizeBytes) && this.evalExamples.equals(other.evalExamples) && this.evalSizeBytes.equals(other.evalSizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.trainableTokenCount, this.totalExamples, this.trainExamples, this.trainSizeBytes, this.evalExamples, this.evalSizeBytes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Long> trainableTokenCount = Optional.empty();
        private Optional<Long> totalExamples = Optional.empty();
        private Optional<Long> trainExamples = Optional.empty();
        private Optional<Long> trainSizeBytes = Optional.empty();
        private Optional<Long> evalExamples = Optional.empty();
        private Optional<Long> evalSizeBytes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FinetuneDatasetMetrics other) {
            this.trainableTokenCount(other.getTrainableTokenCount());
            this.totalExamples(other.getTotalExamples());
            this.trainExamples(other.getTrainExamples());
            this.trainSizeBytes(other.getTrainSizeBytes());
            this.evalExamples(other.getEvalExamples());
            this.evalSizeBytes(other.getEvalSizeBytes());
            return this;
        }

        @JsonSetter(value="trainable_token_count", nulls=Nulls.SKIP)
        public Builder trainableTokenCount(Optional<Long> trainableTokenCount) {
            this.trainableTokenCount = trainableTokenCount;
            return this;
        }

        public Builder trainableTokenCount(Long trainableTokenCount) {
            this.trainableTokenCount = Optional.of(trainableTokenCount);
            return this;
        }

        @JsonSetter(value="total_examples", nulls=Nulls.SKIP)
        public Builder totalExamples(Optional<Long> totalExamples) {
            this.totalExamples = totalExamples;
            return this;
        }

        public Builder totalExamples(Long totalExamples) {
            this.totalExamples = Optional.of(totalExamples);
            return this;
        }

        @JsonSetter(value="train_examples", nulls=Nulls.SKIP)
        public Builder trainExamples(Optional<Long> trainExamples) {
            this.trainExamples = trainExamples;
            return this;
        }

        public Builder trainExamples(Long trainExamples) {
            this.trainExamples = Optional.of(trainExamples);
            return this;
        }

        @JsonSetter(value="train_size_bytes", nulls=Nulls.SKIP)
        public Builder trainSizeBytes(Optional<Long> trainSizeBytes) {
            this.trainSizeBytes = trainSizeBytes;
            return this;
        }

        public Builder trainSizeBytes(Long trainSizeBytes) {
            this.trainSizeBytes = Optional.of(trainSizeBytes);
            return this;
        }

        @JsonSetter(value="eval_examples", nulls=Nulls.SKIP)
        public Builder evalExamples(Optional<Long> evalExamples) {
            this.evalExamples = evalExamples;
            return this;
        }

        public Builder evalExamples(Long evalExamples) {
            this.evalExamples = Optional.of(evalExamples);
            return this;
        }

        @JsonSetter(value="eval_size_bytes", nulls=Nulls.SKIP)
        public Builder evalSizeBytes(Optional<Long> evalSizeBytes) {
            this.evalSizeBytes = evalSizeBytes;
            return this;
        }

        public Builder evalSizeBytes(Long evalSizeBytes) {
            this.evalSizeBytes = Optional.of(evalSizeBytes);
            return this;
        }

        public FinetuneDatasetMetrics build() {
            return new FinetuneDatasetMetrics(this.trainableTokenCount, this.totalExamples, this.trainExamples, this.trainSizeBytes, this.evalExamples, this.evalSizeBytes, this.additionalProperties);
        }
    }
}

