/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.GenerateStreamEnd;
import com.cohere.api.types.GenerateStreamError;
import com.cohere.api.types.GenerateStreamText;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class GenerateStreamedResponse {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private GenerateStreamedResponse(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static GenerateStreamedResponse textGeneration(GenerateStreamText value) {
        return new GenerateStreamedResponse(new TextGenerationValue(value));
    }

    public static GenerateStreamedResponse streamEnd(GenerateStreamEnd value) {
        return new GenerateStreamedResponse(new StreamEndValue(value));
    }

    public static GenerateStreamedResponse streamError(GenerateStreamError value) {
        return new GenerateStreamedResponse(new StreamErrorValue(value));
    }

    public boolean isTextGeneration() {
        return this.value instanceof TextGenerationValue;
    }

    public boolean isStreamEnd() {
        return this.value instanceof StreamEndValue;
    }

    public boolean isStreamError() {
        return this.value instanceof StreamErrorValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<GenerateStreamText> getTextGeneration() {
        if (this.isTextGeneration()) {
            return Optional.of(((TextGenerationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<GenerateStreamEnd> getStreamEnd() {
        if (this.isStreamEnd()) {
            return Optional.of(((StreamEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<GenerateStreamError> getStreamError() {
        if (this.isStreamError()) {
            return Optional.of(((StreamErrorValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "GenerateStreamedResponse{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="stream-error")
    private static final class StreamErrorValue
    implements Value {
        @JsonUnwrapped
        private GenerateStreamError value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StreamErrorValue() {
        }

        private StreamErrorValue(GenerateStreamError value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitStreamError(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof StreamErrorValue && this.equalTo((StreamErrorValue)other);
        }

        private boolean equalTo(StreamErrorValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GenerateStreamedResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="stream-end")
    private static final class StreamEndValue
    implements Value {
        @JsonUnwrapped
        private GenerateStreamEnd value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StreamEndValue() {
        }

        private StreamEndValue(GenerateStreamEnd value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitStreamEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof StreamEndValue && this.equalTo((StreamEndValue)other);
        }

        private boolean equalTo(StreamEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GenerateStreamedResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text-generation")
    private static final class TextGenerationValue
    implements Value {
        @JsonUnwrapped
        private GenerateStreamText value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextGenerationValue() {
        }

        private TextGenerationValue(GenerateStreamText value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTextGeneration(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextGenerationValue && this.equalTo((TextGenerationValue)other);
        }

        private boolean equalTo(TextGenerationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GenerateStreamedResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="event_type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextGenerationValue.class), @JsonSubTypes.Type(value=StreamEndValue.class), @JsonSubTypes.Type(value=StreamErrorValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitTextGeneration(GenerateStreamText var1);

        public T visitStreamEnd(GenerateStreamEnd var1);

        public T visitStreamError(GenerateStreamError var1);

        public T _visitUnknown(Object var1);
    }
}

