/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CompatibleEndpoint;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetModelResponse {
    private final Optional<String> name;
    private final Optional<List<CompatibleEndpoint>> endpoints;
    private final Optional<Boolean> finetuned;
    private final Optional<Double> contextLength;
    private final Optional<String> tokenizerUrl;
    private final Optional<List<CompatibleEndpoint>> defaultEndpoints;
    private final Map<String, Object> additionalProperties;

    private GetModelResponse(Optional<String> name, Optional<List<CompatibleEndpoint>> endpoints, Optional<Boolean> finetuned, Optional<Double> contextLength, Optional<String> tokenizerUrl, Optional<List<CompatibleEndpoint>> defaultEndpoints, Map<String, Object> additionalProperties) {
        this.name = name;
        this.endpoints = endpoints;
        this.finetuned = finetuned;
        this.contextLength = contextLength;
        this.tokenizerUrl = tokenizerUrl;
        this.defaultEndpoints = defaultEndpoints;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="endpoints")
    public Optional<List<CompatibleEndpoint>> getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="finetuned")
    public Optional<Boolean> getFinetuned() {
        return this.finetuned;
    }

    @JsonProperty(value="context_length")
    public Optional<Double> getContextLength() {
        return this.contextLength;
    }

    @JsonProperty(value="tokenizer_url")
    public Optional<String> getTokenizerUrl() {
        return this.tokenizerUrl;
    }

    @JsonProperty(value="default_endpoints")
    public Optional<List<CompatibleEndpoint>> getDefaultEndpoints() {
        return this.defaultEndpoints;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetModelResponse && this.equalTo((GetModelResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetModelResponse other) {
        return this.name.equals(other.name) && this.endpoints.equals(other.endpoints) && this.finetuned.equals(other.finetuned) && this.contextLength.equals(other.contextLength) && this.tokenizerUrl.equals(other.tokenizerUrl) && this.defaultEndpoints.equals(other.defaultEndpoints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.endpoints, this.finetuned, this.contextLength, this.tokenizerUrl, this.defaultEndpoints);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<List<CompatibleEndpoint>> endpoints = Optional.empty();
        private Optional<Boolean> finetuned = Optional.empty();
        private Optional<Double> contextLength = Optional.empty();
        private Optional<String> tokenizerUrl = Optional.empty();
        private Optional<List<CompatibleEndpoint>> defaultEndpoints = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetModelResponse other) {
            this.name(other.getName());
            this.endpoints(other.getEndpoints());
            this.finetuned(other.getFinetuned());
            this.contextLength(other.getContextLength());
            this.tokenizerUrl(other.getTokenizerUrl());
            this.defaultEndpoints(other.getDefaultEndpoints());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="endpoints", nulls=Nulls.SKIP)
        public Builder endpoints(Optional<List<CompatibleEndpoint>> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder endpoints(List<CompatibleEndpoint> endpoints) {
            this.endpoints = Optional.of(endpoints);
            return this;
        }

        @JsonSetter(value="finetuned", nulls=Nulls.SKIP)
        public Builder finetuned(Optional<Boolean> finetuned) {
            this.finetuned = finetuned;
            return this;
        }

        public Builder finetuned(Boolean finetuned) {
            this.finetuned = Optional.of(finetuned);
            return this;
        }

        @JsonSetter(value="context_length", nulls=Nulls.SKIP)
        public Builder contextLength(Optional<Double> contextLength) {
            this.contextLength = contextLength;
            return this;
        }

        public Builder contextLength(Double contextLength) {
            this.contextLength = Optional.of(contextLength);
            return this;
        }

        @JsonSetter(value="tokenizer_url", nulls=Nulls.SKIP)
        public Builder tokenizerUrl(Optional<String> tokenizerUrl) {
            this.tokenizerUrl = tokenizerUrl;
            return this;
        }

        public Builder tokenizerUrl(String tokenizerUrl) {
            this.tokenizerUrl = Optional.of(tokenizerUrl);
            return this;
        }

        @JsonSetter(value="default_endpoints", nulls=Nulls.SKIP)
        public Builder defaultEndpoints(Optional<List<CompatibleEndpoint>> defaultEndpoints) {
            this.defaultEndpoints = defaultEndpoints;
            return this;
        }

        public Builder defaultEndpoints(List<CompatibleEndpoint> defaultEndpoints) {
            this.defaultEndpoints = Optional.of(defaultEndpoints);
            return this;
        }

        public GetModelResponse build() {
            return new GetModelResponse(this.name, this.endpoints, this.finetuned, this.contextLength, this.tokenizerUrl, this.defaultEndpoints, this.additionalProperties);
        }
    }
}

