/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Image {
    private final long width;
    private final long height;
    private final String format;
    private final long bitDepth;
    private final Map<String, Object> additionalProperties;

    private Image(long width, long height, String format, long bitDepth, Map<String, Object> additionalProperties) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.bitDepth = bitDepth;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="width")
    public long getWidth() {
        return this.width;
    }

    @JsonProperty(value="height")
    public long getHeight() {
        return this.height;
    }

    @JsonProperty(value="format")
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="bit_depth")
    public long getBitDepth() {
        return this.bitDepth;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Image && this.equalTo((Image)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Image other) {
        return this.width == other.width && this.height == other.height && this.format.equals(other.format) && this.bitDepth == other.bitDepth;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.format, this.bitDepth);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WidthStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WidthStage,
    HeightStage,
    FormatStage,
    BitDepthStage,
    _FinalStage {
        private long width;
        private long height;
        private String format;
        private long bitDepth;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Image other) {
            this.width(other.getWidth());
            this.height(other.getHeight());
            this.format(other.getFormat());
            this.bitDepth(other.getBitDepth());
            return this;
        }

        @Override
        @JsonSetter(value="width")
        public HeightStage width(long width) {
            this.width = width;
            return this;
        }

        @Override
        @JsonSetter(value="height")
        public FormatStage height(long height) {
            this.height = height;
            return this;
        }

        @Override
        @JsonSetter(value="format")
        public BitDepthStage format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @JsonSetter(value="bit_depth")
        public _FinalStage bitDepth(long bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        @Override
        public Image build() {
            return new Image(this.width, this.height, this.format, this.bitDepth, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Image build();
    }

    public static interface BitDepthStage {
        public _FinalStage bitDepth(long var1);
    }

    public static interface FormatStage {
        public BitDepthStage format(String var1);
    }

    public static interface HeightStage {
        public FormatStage height(long var1);
    }

    public static interface WidthStage {
        public HeightStage width(long var1);

        public Builder from(Image var1);
    }
}

