/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JsonResponseFormat {
    private final Optional<Map<String, Object>> schema;
    private final Map<String, Object> additionalProperties;

    private JsonResponseFormat(Optional<Map<String, Object>> schema, Map<String, Object> additionalProperties) {
        this.schema = schema;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema")
    public Optional<Map<String, Object>> getSchema() {
        return this.schema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JsonResponseFormat && this.equalTo((JsonResponseFormat)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JsonResponseFormat other) {
        return this.schema.equals(other.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Map<String, Object>> schema = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JsonResponseFormat other) {
            this.schema(other.getSchema());
            return this;
        }

        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public Builder schema(Optional<Map<String, Object>> schema) {
            this.schema = schema;
            return this;
        }

        public Builder schema(Map<String, Object> schema) {
            this.schema = Optional.of(schema);
            return this;
        }

        public JsonResponseFormat build() {
            return new JsonResponseFormat(this.schema, this.additionalProperties);
        }
    }
}

