/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogprobItem {
    private final Optional<String> text;
    private final List<Integer> tokenIds;
    private final Optional<List<Double>> logprobs;
    private final Map<String, Object> additionalProperties;

    private LogprobItem(Optional<String> text, List<Integer> tokenIds, Optional<List<Double>> logprobs, Map<String, Object> additionalProperties) {
        this.text = text;
        this.tokenIds = tokenIds;
        this.logprobs = logprobs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    @JsonProperty(value="token_ids")
    public List<Integer> getTokenIds() {
        return this.tokenIds;
    }

    @JsonProperty(value="logprobs")
    public Optional<List<Double>> getLogprobs() {
        return this.logprobs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogprobItem && this.equalTo((LogprobItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LogprobItem other) {
        return this.text.equals(other.text) && this.tokenIds.equals(other.tokenIds) && this.logprobs.equals(other.logprobs);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.tokenIds, this.logprobs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> text = Optional.empty();
        private List<Integer> tokenIds = new ArrayList<Integer>();
        private Optional<List<Double>> logprobs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LogprobItem other) {
            this.text(other.getText());
            this.tokenIds(other.getTokenIds());
            this.logprobs(other.getLogprobs());
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<String> text) {
            this.text = text;
            return this;
        }

        public Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @JsonSetter(value="token_ids", nulls=Nulls.SKIP)
        public Builder tokenIds(List<Integer> tokenIds) {
            this.tokenIds.clear();
            this.tokenIds.addAll(tokenIds);
            return this;
        }

        public Builder addTokenIds(Integer tokenIds) {
            this.tokenIds.add(tokenIds);
            return this;
        }

        public Builder addAllTokenIds(List<Integer> tokenIds) {
            this.tokenIds.addAll(tokenIds);
            return this;
        }

        @JsonSetter(value="logprobs", nulls=Nulls.SKIP)
        public Builder logprobs(Optional<List<Double>> logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder logprobs(List<Double> logprobs) {
            this.logprobs = Optional.of(logprobs);
            return this;
        }

        public LogprobItem build() {
            return new LogprobItem(this.text, this.tokenIds, this.logprobs, this.additionalProperties);
        }
    }
}

