/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.FinetuneDatasetMetrics;
import com.cohere.api.types.MetricsEmbedData;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Metrics {
    private final Optional<FinetuneDatasetMetrics> finetuneDatasetMetrics;
    private final Optional<MetricsEmbedData> embedData;
    private final Map<String, Object> additionalProperties;

    private Metrics(Optional<FinetuneDatasetMetrics> finetuneDatasetMetrics, Optional<MetricsEmbedData> embedData, Map<String, Object> additionalProperties) {
        this.finetuneDatasetMetrics = finetuneDatasetMetrics;
        this.embedData = embedData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="finetune_dataset_metrics")
    public Optional<FinetuneDatasetMetrics> getFinetuneDatasetMetrics() {
        return this.finetuneDatasetMetrics;
    }

    @JsonProperty(value="embed_data")
    public Optional<MetricsEmbedData> getEmbedData() {
        return this.embedData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Metrics && this.equalTo((Metrics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Metrics other) {
        return this.finetuneDatasetMetrics.equals(other.finetuneDatasetMetrics) && this.embedData.equals(other.embedData);
    }

    public int hashCode() {
        return Objects.hash(this.finetuneDatasetMetrics, this.embedData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<FinetuneDatasetMetrics> finetuneDatasetMetrics = Optional.empty();
        private Optional<MetricsEmbedData> embedData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Metrics other) {
            this.finetuneDatasetMetrics(other.getFinetuneDatasetMetrics());
            this.embedData(other.getEmbedData());
            return this;
        }

        @JsonSetter(value="finetune_dataset_metrics", nulls=Nulls.SKIP)
        public Builder finetuneDatasetMetrics(Optional<FinetuneDatasetMetrics> finetuneDatasetMetrics) {
            this.finetuneDatasetMetrics = finetuneDatasetMetrics;
            return this;
        }

        public Builder finetuneDatasetMetrics(FinetuneDatasetMetrics finetuneDatasetMetrics) {
            this.finetuneDatasetMetrics = Optional.of(finetuneDatasetMetrics);
            return this;
        }

        @JsonSetter(value="embed_data", nulls=Nulls.SKIP)
        public Builder embedData(Optional<MetricsEmbedData> embedData) {
            this.embedData = embedData;
            return this;
        }

        public Builder embedData(MetricsEmbedData embedData) {
            this.embedData = Optional.of(embedData);
            return this;
        }

        public Metrics build() {
            return new Metrics(this.finetuneDatasetMetrics, this.embedData, this.additionalProperties);
        }
    }
}

