/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MetricsEmbedDataFieldsItem {
    private final Optional<String> name;
    private final Optional<Double> count;
    private final Map<String, Object> additionalProperties;

    private MetricsEmbedDataFieldsItem(Optional<String> name, Optional<Double> count, Map<String, Object> additionalProperties) {
        this.name = name;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="count")
    public Optional<Double> getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetricsEmbedDataFieldsItem && this.equalTo((MetricsEmbedDataFieldsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetricsEmbedDataFieldsItem other) {
        return this.name.equals(other.name) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Double> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MetricsEmbedDataFieldsItem other) {
            this.name(other.getName());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Double> count) {
            this.count = count;
            return this;
        }

        public Builder count(Double count) {
            this.count = Optional.of(count);
            return this;
        }

        public MetricsEmbedDataFieldsItem build() {
            return new MetricsEmbedDataFieldsItem(this.name, this.count, this.additionalProperties);
        }
    }
}

