/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ParseInfo {
    private final Optional<String> separator;
    private final Optional<String> delimiter;
    private final Map<String, Object> additionalProperties;

    private ParseInfo(Optional<String> separator, Optional<String> delimiter, Map<String, Object> additionalProperties) {
        this.separator = separator;
        this.delimiter = delimiter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="separator")
    public Optional<String> getSeparator() {
        return this.separator;
    }

    @JsonProperty(value="delimiter")
    public Optional<String> getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ParseInfo && this.equalTo((ParseInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ParseInfo other) {
        return this.separator.equals(other.separator) && this.delimiter.equals(other.delimiter);
    }

    public int hashCode() {
        return Objects.hash(this.separator, this.delimiter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> separator = Optional.empty();
        private Optional<String> delimiter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ParseInfo other) {
            this.separator(other.getSeparator());
            this.delimiter(other.getDelimiter());
            return this;
        }

        @JsonSetter(value="separator", nulls=Nulls.SKIP)
        public Builder separator(Optional<String> separator) {
            this.separator = separator;
            return this;
        }

        public Builder separator(String separator) {
            this.separator = Optional.of(separator);
            return this;
        }

        @JsonSetter(value="delimiter", nulls=Nulls.SKIP)
        public Builder delimiter(Optional<String> delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = Optional.of(delimiter);
            return this;
        }

        public ParseInfo build() {
            return new ParseInfo(this.separator, this.delimiter, this.additionalProperties);
        }
    }
}

