/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RerankerDataMetrics {
    private final Optional<Long> numTrainQueries;
    private final Optional<Long> numTrainRelevantPassages;
    private final Optional<Long> numTrainHardNegatives;
    private final Optional<Long> numEvalQueries;
    private final Optional<Long> numEvalRelevantPassages;
    private final Optional<Long> numEvalHardNegatives;
    private final Map<String, Object> additionalProperties;

    private RerankerDataMetrics(Optional<Long> numTrainQueries, Optional<Long> numTrainRelevantPassages, Optional<Long> numTrainHardNegatives, Optional<Long> numEvalQueries, Optional<Long> numEvalRelevantPassages, Optional<Long> numEvalHardNegatives, Map<String, Object> additionalProperties) {
        this.numTrainQueries = numTrainQueries;
        this.numTrainRelevantPassages = numTrainRelevantPassages;
        this.numTrainHardNegatives = numTrainHardNegatives;
        this.numEvalQueries = numEvalQueries;
        this.numEvalRelevantPassages = numEvalRelevantPassages;
        this.numEvalHardNegatives = numEvalHardNegatives;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="num_train_queries")
    public Optional<Long> getNumTrainQueries() {
        return this.numTrainQueries;
    }

    @JsonProperty(value="num_train_relevant_passages")
    public Optional<Long> getNumTrainRelevantPassages() {
        return this.numTrainRelevantPassages;
    }

    @JsonProperty(value="num_train_hard_negatives")
    public Optional<Long> getNumTrainHardNegatives() {
        return this.numTrainHardNegatives;
    }

    @JsonProperty(value="num_eval_queries")
    public Optional<Long> getNumEvalQueries() {
        return this.numEvalQueries;
    }

    @JsonProperty(value="num_eval_relevant_passages")
    public Optional<Long> getNumEvalRelevantPassages() {
        return this.numEvalRelevantPassages;
    }

    @JsonProperty(value="num_eval_hard_negatives")
    public Optional<Long> getNumEvalHardNegatives() {
        return this.numEvalHardNegatives;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RerankerDataMetrics && this.equalTo((RerankerDataMetrics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RerankerDataMetrics other) {
        return this.numTrainQueries.equals(other.numTrainQueries) && this.numTrainRelevantPassages.equals(other.numTrainRelevantPassages) && this.numTrainHardNegatives.equals(other.numTrainHardNegatives) && this.numEvalQueries.equals(other.numEvalQueries) && this.numEvalRelevantPassages.equals(other.numEvalRelevantPassages) && this.numEvalHardNegatives.equals(other.numEvalHardNegatives);
    }

    public int hashCode() {
        return Objects.hash(this.numTrainQueries, this.numTrainRelevantPassages, this.numTrainHardNegatives, this.numEvalQueries, this.numEvalRelevantPassages, this.numEvalHardNegatives);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Long> numTrainQueries = Optional.empty();
        private Optional<Long> numTrainRelevantPassages = Optional.empty();
        private Optional<Long> numTrainHardNegatives = Optional.empty();
        private Optional<Long> numEvalQueries = Optional.empty();
        private Optional<Long> numEvalRelevantPassages = Optional.empty();
        private Optional<Long> numEvalHardNegatives = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RerankerDataMetrics other) {
            this.numTrainQueries(other.getNumTrainQueries());
            this.numTrainRelevantPassages(other.getNumTrainRelevantPassages());
            this.numTrainHardNegatives(other.getNumTrainHardNegatives());
            this.numEvalQueries(other.getNumEvalQueries());
            this.numEvalRelevantPassages(other.getNumEvalRelevantPassages());
            this.numEvalHardNegatives(other.getNumEvalHardNegatives());
            return this;
        }

        @JsonSetter(value="num_train_queries", nulls=Nulls.SKIP)
        public Builder numTrainQueries(Optional<Long> numTrainQueries) {
            this.numTrainQueries = numTrainQueries;
            return this;
        }

        public Builder numTrainQueries(Long numTrainQueries) {
            this.numTrainQueries = Optional.of(numTrainQueries);
            return this;
        }

        @JsonSetter(value="num_train_relevant_passages", nulls=Nulls.SKIP)
        public Builder numTrainRelevantPassages(Optional<Long> numTrainRelevantPassages) {
            this.numTrainRelevantPassages = numTrainRelevantPassages;
            return this;
        }

        public Builder numTrainRelevantPassages(Long numTrainRelevantPassages) {
            this.numTrainRelevantPassages = Optional.of(numTrainRelevantPassages);
            return this;
        }

        @JsonSetter(value="num_train_hard_negatives", nulls=Nulls.SKIP)
        public Builder numTrainHardNegatives(Optional<Long> numTrainHardNegatives) {
            this.numTrainHardNegatives = numTrainHardNegatives;
            return this;
        }

        public Builder numTrainHardNegatives(Long numTrainHardNegatives) {
            this.numTrainHardNegatives = Optional.of(numTrainHardNegatives);
            return this;
        }

        @JsonSetter(value="num_eval_queries", nulls=Nulls.SKIP)
        public Builder numEvalQueries(Optional<Long> numEvalQueries) {
            this.numEvalQueries = numEvalQueries;
            return this;
        }

        public Builder numEvalQueries(Long numEvalQueries) {
            this.numEvalQueries = Optional.of(numEvalQueries);
            return this;
        }

        @JsonSetter(value="num_eval_relevant_passages", nulls=Nulls.SKIP)
        public Builder numEvalRelevantPassages(Optional<Long> numEvalRelevantPassages) {
            this.numEvalRelevantPassages = numEvalRelevantPassages;
            return this;
        }

        public Builder numEvalRelevantPassages(Long numEvalRelevantPassages) {
            this.numEvalRelevantPassages = Optional.of(numEvalRelevantPassages);
            return this;
        }

        @JsonSetter(value="num_eval_hard_negatives", nulls=Nulls.SKIP)
        public Builder numEvalHardNegatives(Optional<Long> numEvalHardNegatives) {
            this.numEvalHardNegatives = numEvalHardNegatives;
            return this;
        }

        public Builder numEvalHardNegatives(Long numEvalHardNegatives) {
            this.numEvalHardNegatives = Optional.of(numEvalHardNegatives);
            return this;
        }

        public RerankerDataMetrics build() {
            return new RerankerDataMetrics(this.numTrainQueries, this.numTrainRelevantPassages, this.numTrainHardNegatives, this.numEvalQueries, this.numEvalRelevantPassages, this.numEvalHardNegatives, this.additionalProperties);
        }
    }
}

