/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.JsonResponseFormatV2;
import com.cohere.api.types.TextResponseFormatV2;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class ResponseFormatV2 {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ResponseFormatV2(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static ResponseFormatV2 text(TextResponseFormatV2 value) {
        return new ResponseFormatV2(new TextValue(value));
    }

    public static ResponseFormatV2 jsonObject(JsonResponseFormatV2 value) {
        return new ResponseFormatV2(new JsonObjectValue(value));
    }

    public boolean isText() {
        return this.value instanceof TextValue;
    }

    public boolean isJsonObject() {
        return this.value instanceof JsonObjectValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<TextResponseFormatV2> getText() {
        if (this.isText()) {
            return Optional.of(((TextValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<JsonResponseFormatV2> getJsonObject() {
        if (this.isJsonObject()) {
            return Optional.of(((JsonObjectValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "ResponseFormatV2{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="json_object")
    private static final class JsonObjectValue
    implements Value {
        @JsonUnwrapped
        private JsonResponseFormatV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private JsonObjectValue() {
        }

        private JsonObjectValue(JsonResponseFormatV2 value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitJsonObject(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof JsonObjectValue && this.equalTo((JsonObjectValue)other);
        }

        private boolean equalTo(JsonObjectValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ResponseFormatV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text")
    private static final class TextValue
    implements Value {
        @JsonUnwrapped
        private TextResponseFormatV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextValue() {
        }

        private TextValue(TextResponseFormatV2 value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextValue && this.equalTo((TextValue)other);
        }

        private boolean equalTo(TextValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ResponseFormatV2{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextValue.class), @JsonSubTypes.Type(value=JsonObjectValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitText(TextResponseFormatV2 var1);

        public T visitJsonObject(JsonResponseFormatV2 var1);

        public T _visitUnknown(Object var1);
    }
}

