/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.SingleGenerationTokenLikelihoodsItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SingleGeneration {
    private final String id;
    private final String text;
    private final Optional<Integer> index;
    private final Optional<Double> likelihood;
    private final Optional<List<SingleGenerationTokenLikelihoodsItem>> tokenLikelihoods;
    private final Map<String, Object> additionalProperties;

    private SingleGeneration(String id, String text, Optional<Integer> index, Optional<Double> likelihood, Optional<List<SingleGenerationTokenLikelihoodsItem>> tokenLikelihoods, Map<String, Object> additionalProperties) {
        this.id = id;
        this.text = text;
        this.index = index;
        this.likelihood = likelihood;
        this.tokenLikelihoods = tokenLikelihoods;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="likelihood")
    public Optional<Double> getLikelihood() {
        return this.likelihood;
    }

    @JsonProperty(value="token_likelihoods")
    public Optional<List<SingleGenerationTokenLikelihoodsItem>> getTokenLikelihoods() {
        return this.tokenLikelihoods;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SingleGeneration && this.equalTo((SingleGeneration)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SingleGeneration other) {
        return this.id.equals(other.id) && this.text.equals(other.text) && this.index.equals(other.index) && this.likelihood.equals(other.likelihood) && this.tokenLikelihoods.equals(other.tokenLikelihoods);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.index, this.likelihood, this.tokenLikelihoods);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TextStage,
    _FinalStage {
        private String id;
        private String text;
        private Optional<List<SingleGenerationTokenLikelihoodsItem>> tokenLikelihoods = Optional.empty();
        private Optional<Double> likelihood = Optional.empty();
        private Optional<Integer> index = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SingleGeneration other) {
            this.id(other.getId());
            this.text(other.getText());
            this.index(other.getIndex());
            this.likelihood(other.getLikelihood());
            this.tokenLikelihoods(other.getTokenLikelihoods());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TextStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage tokenLikelihoods(List<SingleGenerationTokenLikelihoodsItem> tokenLikelihoods) {
            this.tokenLikelihoods = Optional.of(tokenLikelihoods);
            return this;
        }

        @Override
        @JsonSetter(value="token_likelihoods", nulls=Nulls.SKIP)
        public _FinalStage tokenLikelihoods(Optional<List<SingleGenerationTokenLikelihoodsItem>> tokenLikelihoods) {
            this.tokenLikelihoods = tokenLikelihoods;
            return this;
        }

        @Override
        public _FinalStage likelihood(Double likelihood) {
            this.likelihood = Optional.of(likelihood);
            return this;
        }

        @Override
        @JsonSetter(value="likelihood", nulls=Nulls.SKIP)
        public _FinalStage likelihood(Optional<Double> likelihood) {
            this.likelihood = likelihood;
            return this;
        }

        @Override
        public _FinalStage index(Integer index) {
            this.index = Optional.of(index);
            return this;
        }

        @Override
        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public _FinalStage index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        @Override
        public SingleGeneration build() {
            return new SingleGeneration(this.id, this.text, this.index, this.likelihood, this.tokenLikelihoods, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SingleGeneration build();

        public _FinalStage index(Optional<Integer> var1);

        public _FinalStage index(Integer var1);

        public _FinalStage likelihood(Optional<Double> var1);

        public _FinalStage likelihood(Double var1);

        public _FinalStage tokenLikelihoods(Optional<List<SingleGenerationTokenLikelihoodsItem>> var1);

        public _FinalStage tokenLikelihoods(List<SingleGenerationTokenLikelihoodsItem> var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);
    }

    public static interface IdStage {
        public TextStage id(String var1);

        public Builder from(SingleGeneration var1);
    }
}

