/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.ChatContentDeltaEvent;
import com.cohere.api.types.ChatContentEndEvent;
import com.cohere.api.types.ChatContentStartEvent;
import com.cohere.api.types.ChatMessageEndEvent;
import com.cohere.api.types.ChatMessageStartEvent;
import com.cohere.api.types.ChatToolCallDeltaEvent;
import com.cohere.api.types.ChatToolCallEndEvent;
import com.cohere.api.types.ChatToolCallStartEvent;
import com.cohere.api.types.ChatToolPlanDeltaEvent;
import com.cohere.api.types.CitationEndEvent;
import com.cohere.api.types.CitationStartEvent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class StreamedChatResponseV2 {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private StreamedChatResponseV2(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static StreamedChatResponseV2 messageStart(ChatMessageStartEvent value) {
        return new StreamedChatResponseV2(new MessageStartValue(value));
    }

    public static StreamedChatResponseV2 contentStart(ChatContentStartEvent value) {
        return new StreamedChatResponseV2(new ContentStartValue(value));
    }

    public static StreamedChatResponseV2 contentDelta(ChatContentDeltaEvent value) {
        return new StreamedChatResponseV2(new ContentDeltaValue(value));
    }

    public static StreamedChatResponseV2 contentEnd(ChatContentEndEvent value) {
        return new StreamedChatResponseV2(new ContentEndValue(value));
    }

    public static StreamedChatResponseV2 toolPlanDelta(ChatToolPlanDeltaEvent value) {
        return new StreamedChatResponseV2(new ToolPlanDeltaValue(value));
    }

    public static StreamedChatResponseV2 toolCallStart(ChatToolCallStartEvent value) {
        return new StreamedChatResponseV2(new ToolCallStartValue(value));
    }

    public static StreamedChatResponseV2 toolCallDelta(ChatToolCallDeltaEvent value) {
        return new StreamedChatResponseV2(new ToolCallDeltaValue(value));
    }

    public static StreamedChatResponseV2 toolCallEnd(ChatToolCallEndEvent value) {
        return new StreamedChatResponseV2(new ToolCallEndValue(value));
    }

    public static StreamedChatResponseV2 citationStart(CitationStartEvent value) {
        return new StreamedChatResponseV2(new CitationStartValue(value));
    }

    public static StreamedChatResponseV2 citationEnd(CitationEndEvent value) {
        return new StreamedChatResponseV2(new CitationEndValue(value));
    }

    public static StreamedChatResponseV2 messageEnd(ChatMessageEndEvent value) {
        return new StreamedChatResponseV2(new MessageEndValue(value));
    }

    public boolean isMessageStart() {
        return this.value instanceof MessageStartValue;
    }

    public boolean isContentStart() {
        return this.value instanceof ContentStartValue;
    }

    public boolean isContentDelta() {
        return this.value instanceof ContentDeltaValue;
    }

    public boolean isContentEnd() {
        return this.value instanceof ContentEndValue;
    }

    public boolean isToolPlanDelta() {
        return this.value instanceof ToolPlanDeltaValue;
    }

    public boolean isToolCallStart() {
        return this.value instanceof ToolCallStartValue;
    }

    public boolean isToolCallDelta() {
        return this.value instanceof ToolCallDeltaValue;
    }

    public boolean isToolCallEnd() {
        return this.value instanceof ToolCallEndValue;
    }

    public boolean isCitationStart() {
        return this.value instanceof CitationStartValue;
    }

    public boolean isCitationEnd() {
        return this.value instanceof CitationEndValue;
    }

    public boolean isMessageEnd() {
        return this.value instanceof MessageEndValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ChatMessageStartEvent> getMessageStart() {
        if (this.isMessageStart()) {
            return Optional.of(((MessageStartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatContentStartEvent> getContentStart() {
        if (this.isContentStart()) {
            return Optional.of(((ContentStartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatContentDeltaEvent> getContentDelta() {
        if (this.isContentDelta()) {
            return Optional.of(((ContentDeltaValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatContentEndEvent> getContentEnd() {
        if (this.isContentEnd()) {
            return Optional.of(((ContentEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolPlanDeltaEvent> getToolPlanDelta() {
        if (this.isToolPlanDelta()) {
            return Optional.of(((ToolPlanDeltaValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolCallStartEvent> getToolCallStart() {
        if (this.isToolCallStart()) {
            return Optional.of(((ToolCallStartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolCallDeltaEvent> getToolCallDelta() {
        if (this.isToolCallDelta()) {
            return Optional.of(((ToolCallDeltaValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolCallEndEvent> getToolCallEnd() {
        if (this.isToolCallEnd()) {
            return Optional.of(((ToolCallEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CitationStartEvent> getCitationStart() {
        if (this.isCitationStart()) {
            return Optional.of(((CitationStartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CitationEndEvent> getCitationEnd() {
        if (this.isCitationEnd()) {
            return Optional.of(((CitationEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatMessageEndEvent> getMessageEnd() {
        if (this.isMessageEnd()) {
            return Optional.of(((MessageEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="message-end")
    private static final class MessageEndValue
    implements Value {
        @JsonUnwrapped
        private ChatMessageEndEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MessageEndValue() {
        }

        private MessageEndValue(ChatMessageEndEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMessageEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MessageEndValue && this.equalTo((MessageEndValue)other);
        }

        private boolean equalTo(MessageEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="citation-end")
    private static final class CitationEndValue
    implements Value {
        @JsonUnwrapped
        private CitationEndEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CitationEndValue() {
        }

        private CitationEndValue(CitationEndEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCitationEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CitationEndValue && this.equalTo((CitationEndValue)other);
        }

        private boolean equalTo(CitationEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="citation-start")
    private static final class CitationStartValue
    implements Value {
        @JsonUnwrapped
        private CitationStartEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CitationStartValue() {
        }

        private CitationStartValue(CitationStartEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCitationStart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CitationStartValue && this.equalTo((CitationStartValue)other);
        }

        private boolean equalTo(CitationStartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-call-end")
    private static final class ToolCallEndValue
    implements Value {
        @JsonUnwrapped
        private ChatToolCallEndEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolCallEndValue() {
        }

        private ToolCallEndValue(ChatToolCallEndEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolCallEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolCallEndValue && this.equalTo((ToolCallEndValue)other);
        }

        private boolean equalTo(ToolCallEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-call-delta")
    private static final class ToolCallDeltaValue
    implements Value {
        @JsonUnwrapped
        private ChatToolCallDeltaEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolCallDeltaValue() {
        }

        private ToolCallDeltaValue(ChatToolCallDeltaEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolCallDelta(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolCallDeltaValue && this.equalTo((ToolCallDeltaValue)other);
        }

        private boolean equalTo(ToolCallDeltaValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-call-start")
    private static final class ToolCallStartValue
    implements Value {
        @JsonUnwrapped
        private ChatToolCallStartEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolCallStartValue() {
        }

        private ToolCallStartValue(ChatToolCallStartEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolCallStart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolCallStartValue && this.equalTo((ToolCallStartValue)other);
        }

        private boolean equalTo(ToolCallStartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-plan-delta")
    private static final class ToolPlanDeltaValue
    implements Value {
        @JsonUnwrapped
        private ChatToolPlanDeltaEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolPlanDeltaValue() {
        }

        private ToolPlanDeltaValue(ChatToolPlanDeltaEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolPlanDelta(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolPlanDeltaValue && this.equalTo((ToolPlanDeltaValue)other);
        }

        private boolean equalTo(ToolPlanDeltaValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="content-end")
    private static final class ContentEndValue
    implements Value {
        @JsonUnwrapped
        private ChatContentEndEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ContentEndValue() {
        }

        private ContentEndValue(ChatContentEndEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitContentEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ContentEndValue && this.equalTo((ContentEndValue)other);
        }

        private boolean equalTo(ContentEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="content-delta")
    private static final class ContentDeltaValue
    implements Value {
        @JsonUnwrapped
        private ChatContentDeltaEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ContentDeltaValue() {
        }

        private ContentDeltaValue(ChatContentDeltaEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitContentDelta(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ContentDeltaValue && this.equalTo((ContentDeltaValue)other);
        }

        private boolean equalTo(ContentDeltaValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="content-start")
    private static final class ContentStartValue
    implements Value {
        @JsonUnwrapped
        private ChatContentStartEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ContentStartValue() {
        }

        private ContentStartValue(ChatContentStartEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitContentStart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ContentStartValue && this.equalTo((ContentStartValue)other);
        }

        private boolean equalTo(ContentStartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="message-start")
    private static final class MessageStartValue
    implements Value {
        @JsonUnwrapped
        private ChatMessageStartEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MessageStartValue() {
        }

        private MessageStartValue(ChatMessageStartEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMessageStart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MessageStartValue && this.equalTo((MessageStartValue)other);
        }

        private boolean equalTo(MessageStartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponseV2{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=MessageStartValue.class), @JsonSubTypes.Type(value=ContentStartValue.class), @JsonSubTypes.Type(value=ContentDeltaValue.class), @JsonSubTypes.Type(value=ContentEndValue.class), @JsonSubTypes.Type(value=ToolPlanDeltaValue.class), @JsonSubTypes.Type(value=ToolCallStartValue.class), @JsonSubTypes.Type(value=ToolCallDeltaValue.class), @JsonSubTypes.Type(value=ToolCallEndValue.class), @JsonSubTypes.Type(value=CitationStartValue.class), @JsonSubTypes.Type(value=CitationEndValue.class), @JsonSubTypes.Type(value=MessageEndValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitMessageStart(ChatMessageStartEvent var1);

        public T visitContentStart(ChatContentStartEvent var1);

        public T visitContentDelta(ChatContentDeltaEvent var1);

        public T visitContentEnd(ChatContentEndEvent var1);

        public T visitToolPlanDelta(ChatToolPlanDeltaEvent var1);

        public T visitToolCallStart(ChatToolCallStartEvent var1);

        public T visitToolCallDelta(ChatToolCallDeltaEvent var1);

        public T visitToolCallEnd(ChatToolCallEndEvent var1);

        public T visitCitationStart(CitationStartEvent var1);

        public T visitCitationEnd(CitationEndEvent var1);

        public T visitMessageEnd(ChatMessageEndEvent var1);

        public T _visitUnknown(Object var1);
    }
}

