/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.SystemMessageContent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SystemMessage {
    private final SystemMessageContent content;
    private final Map<String, Object> additionalProperties;

    private SystemMessage(SystemMessageContent content, Map<String, Object> additionalProperties) {
        this.content = content;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content")
    public SystemMessageContent getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SystemMessage && this.equalTo((SystemMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SystemMessage other) {
        return this.content.equals(other.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContentStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContentStage,
    _FinalStage {
        private SystemMessageContent content;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SystemMessage other) {
            this.content(other.getContent());
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(SystemMessageContent content) {
            this.content = content;
            return this;
        }

        @Override
        public SystemMessage build() {
            return new SystemMessage(this.content, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SystemMessage build();
    }

    public static interface ContentStage {
        public _FinalStage content(SystemMessageContent var1);

        public Builder from(SystemMessage var1);
    }
}

