/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolParameterDefinitionsValue;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Tool {
    private final String name;
    private final String description;
    private final Optional<Map<String, ToolParameterDefinitionsValue>> parameterDefinitions;
    private final Map<String, Object> additionalProperties;

    private Tool(String name, String description, Optional<Map<String, ToolParameterDefinitionsValue>> parameterDefinitions, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.parameterDefinitions = parameterDefinitions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="parameter_definitions")
    public Optional<Map<String, ToolParameterDefinitionsValue>> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Tool && this.equalTo((Tool)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tool other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.parameterDefinitions.equals(other.parameterDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.parameterDefinitions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DescriptionStage,
    _FinalStage {
        private String name;
        private String description;
        private Optional<Map<String, ToolParameterDefinitionsValue>> parameterDefinitions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Tool other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.parameterDefinitions(other.getParameterDefinitions());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public _FinalStage description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage parameterDefinitions(Map<String, ToolParameterDefinitionsValue> parameterDefinitions) {
            this.parameterDefinitions = Optional.of(parameterDefinitions);
            return this;
        }

        @Override
        @JsonSetter(value="parameter_definitions", nulls=Nulls.SKIP)
        public _FinalStage parameterDefinitions(Optional<Map<String, ToolParameterDefinitionsValue>> parameterDefinitions) {
            this.parameterDefinitions = parameterDefinitions;
            return this;
        }

        @Override
        public Tool build() {
            return new Tool(this.name, this.description, this.parameterDefinitions, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Tool build();

        public _FinalStage parameterDefinitions(Optional<Map<String, ToolParameterDefinitionsValue>> var1);

        public _FinalStage parameterDefinitions(Map<String, ToolParameterDefinitionsValue> var1);
    }

    public static interface DescriptionStage {
        public _FinalStage description(String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(String var1);

        public Builder from(Tool var1);
    }
}

