/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolCallDelta {
    private final Optional<String> name;
    private final Optional<Double> index;
    private final Optional<String> parameters;
    private final Optional<String> text;
    private final Map<String, Object> additionalProperties;

    private ToolCallDelta(Optional<String> name, Optional<Double> index, Optional<String> parameters, Optional<String> text, Map<String, Object> additionalProperties) {
        this.name = name;
        this.index = index;
        this.parameters = parameters;
        this.text = text;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="index")
    public Optional<Double> getIndex() {
        return this.index;
    }

    @JsonProperty(value="parameters")
    public Optional<String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolCallDelta && this.equalTo((ToolCallDelta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolCallDelta other) {
        return this.name.equals(other.name) && this.index.equals(other.index) && this.parameters.equals(other.parameters) && this.text.equals(other.text);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.index, this.parameters, this.text);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Double> index = Optional.empty();
        private Optional<String> parameters = Optional.empty();
        private Optional<String> text = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ToolCallDelta other) {
            this.name(other.getName());
            this.index(other.getIndex());
            this.parameters(other.getParameters());
            this.text(other.getText());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public Builder index(Optional<Double> index) {
            this.index = index;
            return this;
        }

        public Builder index(Double index) {
            this.index = Optional.of(index);
            return this;
        }

        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public Builder parameters(Optional<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder parameters(String parameters) {
            this.parameters = Optional.of(parameters);
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<String> text) {
            this.text = text;
            return this;
        }

        public Builder text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        public ToolCallDelta build() {
            return new ToolCallDelta(this.name, this.index, this.parameters, this.text, this.additionalProperties);
        }
    }
}

