/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolCallV2Function {
    private final Optional<String> name;
    private final Optional<String> arguments;
    private final Map<String, Object> additionalProperties;

    private ToolCallV2Function(Optional<String> name, Optional<String> arguments, Map<String, Object> additionalProperties) {
        this.name = name;
        this.arguments = arguments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="arguments")
    public Optional<String> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolCallV2Function && this.equalTo((ToolCallV2Function)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolCallV2Function other) {
        return this.name.equals(other.name) && this.arguments.equals(other.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> arguments = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ToolCallV2Function other) {
            this.name(other.getName());
            this.arguments(other.getArguments());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="arguments", nulls=Nulls.SKIP)
        public Builder arguments(Optional<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder arguments(String arguments) {
            this.arguments = Optional.of(arguments);
            return this;
        }

        public ToolCallV2Function build() {
            return new ToolCallV2Function(this.name, this.arguments, this.additionalProperties);
        }
    }
}

