/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.DocumentContent;
import com.cohere.api.types.TextContent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class ToolContent {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ToolContent(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static ToolContent text(TextContent value) {
        return new ToolContent(new TextValue(value));
    }

    public static ToolContent document(DocumentContent value) {
        return new ToolContent(new DocumentValue(value));
    }

    public boolean isText() {
        return this.value instanceof TextValue;
    }

    public boolean isDocument() {
        return this.value instanceof DocumentValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<TextContent> getText() {
        if (this.isText()) {
            return Optional.of(((TextValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<DocumentContent> getDocument() {
        if (this.isDocument()) {
            return Optional.of(((DocumentValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "ToolContent{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="document")
    private static final class DocumentValue
    implements Value {
        @JsonUnwrapped
        private DocumentContent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DocumentValue() {
        }

        private DocumentValue(DocumentContent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDocument(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DocumentValue && this.equalTo((DocumentValue)other);
        }

        private boolean equalTo(DocumentValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ToolContent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text")
    private static final class TextValue
    implements Value {
        @JsonUnwrapped
        private TextContent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextValue() {
        }

        private TextValue(TextContent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextValue && this.equalTo((TextValue)other);
        }

        private boolean equalTo(TextValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ToolContent{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextValue.class), @JsonSubTypes.Type(value=DocumentValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitText(TextContent var1);

        public T visitDocument(DocumentContent var1);

        public T _visitUnknown(Object var1);
    }
}

