/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolResult;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolMessage {
    private final Optional<List<ToolResult>> toolResults;
    private final Map<String, Object> additionalProperties;

    private ToolMessage(Optional<List<ToolResult>> toolResults, Map<String, Object> additionalProperties) {
        this.toolResults = toolResults;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tool_results")
    public Optional<List<ToolResult>> getToolResults() {
        return this.toolResults;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolMessage && this.equalTo((ToolMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolMessage other) {
        return this.toolResults.equals(other.toolResults);
    }

    public int hashCode() {
        return Objects.hash(this.toolResults);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<ToolResult>> toolResults = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ToolMessage other) {
            this.toolResults(other.getToolResults());
            return this;
        }

        @JsonSetter(value="tool_results", nulls=Nulls.SKIP)
        public Builder toolResults(Optional<List<ToolResult>> toolResults) {
            this.toolResults = toolResults;
            return this;
        }

        public Builder toolResults(List<ToolResult> toolResults) {
            this.toolResults = Optional.of(toolResults);
            return this;
        }

        public ToolMessage build() {
            return new ToolMessage(this.toolResults, this.additionalProperties);
        }
    }
}

