/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolCall;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolResult {
    private final ToolCall call;
    private final List<Map<String, Object>> outputs;
    private final Map<String, Object> additionalProperties;

    private ToolResult(ToolCall call, List<Map<String, Object>> outputs, Map<String, Object> additionalProperties) {
        this.call = call;
        this.outputs = outputs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="call")
    public ToolCall getCall() {
        return this.call;
    }

    @JsonProperty(value="outputs")
    public List<Map<String, Object>> getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolResult && this.equalTo((ToolResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolResult other) {
        return this.call.equals(other.call) && this.outputs.equals(other.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.call, this.outputs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CallStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CallStage,
    _FinalStage {
        private ToolCall call;
        private List<Map<String, Object>> outputs = new ArrayList<Map<String, Object>>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ToolResult other) {
            this.call(other.getCall());
            this.outputs(other.getOutputs());
            return this;
        }

        @Override
        @JsonSetter(value="call")
        public _FinalStage call(ToolCall call) {
            this.call = call;
            return this;
        }

        @Override
        public _FinalStage addAllOutputs(List<Map<String, Object>> outputs) {
            this.outputs.addAll(outputs);
            return this;
        }

        @Override
        public _FinalStage addOutputs(Map<String, Object> outputs) {
            this.outputs.add(outputs);
            return this;
        }

        @Override
        @JsonSetter(value="outputs", nulls=Nulls.SKIP)
        public _FinalStage outputs(List<Map<String, Object>> outputs) {
            this.outputs.clear();
            this.outputs.addAll(outputs);
            return this;
        }

        @Override
        public ToolResult build() {
            return new ToolResult(this.call, this.outputs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ToolResult build();

        public _FinalStage outputs(List<Map<String, Object>> var1);

        public _FinalStage addOutputs(Map<String, Object> var1);

        public _FinalStage addAllOutputs(List<Map<String, Object>> var1);
    }

    public static interface CallStage {
        public _FinalStage call(ToolCall var1);

        public Builder from(ToolResult var1);
    }
}

