/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolSource {
    private final Optional<String> id;
    private final Optional<Map<String, Object>> toolOutput;
    private final Map<String, Object> additionalProperties;

    private ToolSource(Optional<String> id, Optional<Map<String, Object>> toolOutput, Map<String, Object> additionalProperties) {
        this.id = id;
        this.toolOutput = toolOutput;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="tool_output")
    public Optional<Map<String, Object>> getToolOutput() {
        return this.toolOutput;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolSource && this.equalTo((ToolSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolSource other) {
        return this.id.equals(other.id) && this.toolOutput.equals(other.toolOutput);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.toolOutput);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Map<String, Object>> toolOutput = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ToolSource other) {
            this.id(other.getId());
            this.toolOutput(other.getToolOutput());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="tool_output", nulls=Nulls.SKIP)
        public Builder toolOutput(Optional<Map<String, Object>> toolOutput) {
            this.toolOutput = toolOutput;
            return this;
        }

        public Builder toolOutput(Map<String, Object> toolOutput) {
            this.toolOutput = Optional.of(toolOutput);
            return this;
        }

        public ToolSource build() {
            return new ToolSource(this.id, this.toolOutput, this.additionalProperties);
        }
    }
}

