/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ToolV2Function {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Map<String, Object>> parameters;
    private final Map<String, Object> additionalProperties;

    private ToolV2Function(Optional<String> name, Optional<String> description, Optional<Map<String, Object>> parameters, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="parameters")
    public Optional<Map<String, Object>> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolV2Function && this.equalTo((ToolV2Function)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolV2Function other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.parameters);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Map<String, Object>> parameters = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ToolV2Function other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.parameters(other.getParameters());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public Builder parameters(Optional<Map<String, Object>> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = Optional.of(parameters);
            return this;
        }

        public ToolV2Function build() {
            return new ToolV2Function(this.name, this.description, this.parameters, this.additionalProperties);
        }
    }
}

