/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api;

import com.cohere.api.CohereBuilder;
import com.cohere.api.RawCohere;
import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.Suppliers;
import com.cohere.api.requests.ChatRequest;
import com.cohere.api.requests.ChatStreamRequest;
import com.cohere.api.requests.ClassifyRequest;
import com.cohere.api.requests.DetokenizeRequest;
import com.cohere.api.requests.EmbedRequest;
import com.cohere.api.requests.GenerateRequest;
import com.cohere.api.requests.GenerateStreamRequest;
import com.cohere.api.requests.RerankRequest;
import com.cohere.api.requests.SummarizeRequest;
import com.cohere.api.requests.TokenizeRequest;
import com.cohere.api.resources.connectors.ConnectorsClient;
import com.cohere.api.resources.datasets.DatasetsClient;
import com.cohere.api.resources.embedjobs.EmbedJobsClient;
import com.cohere.api.resources.finetuning.FinetuningClient;
import com.cohere.api.resources.models.ModelsClient;
import com.cohere.api.resources.v2.V2Client;
import com.cohere.api.types.CheckApiKeyResponse;
import com.cohere.api.types.ClassifyResponse;
import com.cohere.api.types.DetokenizeResponse;
import com.cohere.api.types.EmbedResponse;
import com.cohere.api.types.GenerateStreamedResponse;
import com.cohere.api.types.Generation;
import com.cohere.api.types.NonStreamedChatResponse;
import com.cohere.api.types.RerankResponse;
import com.cohere.api.types.StreamedChatResponse;
import com.cohere.api.types.SummarizeResponse;
import com.cohere.api.types.TokenizeResponse;
import java.util.function.Supplier;

public class Cohere {
    protected final ClientOptions clientOptions;
    private final RawCohere rawClient;
    protected final Supplier<V2Client> v2Client;
    protected final Supplier<EmbedJobsClient> embedJobsClient;
    protected final Supplier<DatasetsClient> datasetsClient;
    protected final Supplier<ConnectorsClient> connectorsClient;
    protected final Supplier<ModelsClient> modelsClient;
    protected final Supplier<FinetuningClient> finetuningClient;

    public Cohere(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCohere(clientOptions);
        this.v2Client = Suppliers.memoize(() -> new V2Client(clientOptions));
        this.embedJobsClient = Suppliers.memoize(() -> new EmbedJobsClient(clientOptions));
        this.datasetsClient = Suppliers.memoize(() -> new DatasetsClient(clientOptions));
        this.connectorsClient = Suppliers.memoize(() -> new ConnectorsClient(clientOptions));
        this.modelsClient = Suppliers.memoize(() -> new ModelsClient(clientOptions));
        this.finetuningClient = Suppliers.memoize(() -> new FinetuningClient(clientOptions));
    }

    public RawCohere withRawResponse() {
        return this.rawClient;
    }

    public Iterable<StreamedChatResponse> chatStream(ChatStreamRequest request) {
        return this.rawClient.chatStream(request).body();
    }

    public Iterable<StreamedChatResponse> chatStream(ChatStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.chatStream(request, requestOptions).body();
    }

    public NonStreamedChatResponse chat(ChatRequest request) {
        return this.rawClient.chat(request).body();
    }

    public NonStreamedChatResponse chat(ChatRequest request, RequestOptions requestOptions) {
        return this.rawClient.chat(request, requestOptions).body();
    }

    public Iterable<GenerateStreamedResponse> generateStream(GenerateStreamRequest request) {
        return this.rawClient.generateStream(request).body();
    }

    public Iterable<GenerateStreamedResponse> generateStream(GenerateStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.generateStream(request, requestOptions).body();
    }

    public Generation generate(GenerateRequest request) {
        return this.rawClient.generate(request).body();
    }

    public Generation generate(GenerateRequest request, RequestOptions requestOptions) {
        return this.rawClient.generate(request, requestOptions).body();
    }

    public EmbedResponse embed() {
        return this.rawClient.embed().body();
    }

    public EmbedResponse embed(EmbedRequest request) {
        return this.rawClient.embed(request).body();
    }

    public EmbedResponse embed(EmbedRequest request, RequestOptions requestOptions) {
        return this.rawClient.embed(request, requestOptions).body();
    }

    public RerankResponse rerank(RerankRequest request) {
        return this.rawClient.rerank(request).body();
    }

    public RerankResponse rerank(RerankRequest request, RequestOptions requestOptions) {
        return this.rawClient.rerank(request, requestOptions).body();
    }

    public ClassifyResponse classify(ClassifyRequest request) {
        return this.rawClient.classify(request).body();
    }

    public ClassifyResponse classify(ClassifyRequest request, RequestOptions requestOptions) {
        return this.rawClient.classify(request, requestOptions).body();
    }

    public SummarizeResponse summarize(SummarizeRequest request) {
        return this.rawClient.summarize(request).body();
    }

    public SummarizeResponse summarize(SummarizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.summarize(request, requestOptions).body();
    }

    public TokenizeResponse tokenize(TokenizeRequest request) {
        return this.rawClient.tokenize(request).body();
    }

    public TokenizeResponse tokenize(TokenizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.tokenize(request, requestOptions).body();
    }

    public DetokenizeResponse detokenize(DetokenizeRequest request) {
        return this.rawClient.detokenize(request).body();
    }

    public DetokenizeResponse detokenize(DetokenizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.detokenize(request, requestOptions).body();
    }

    public CheckApiKeyResponse checkApiKey() {
        return this.rawClient.checkApiKey().body();
    }

    public CheckApiKeyResponse checkApiKey(RequestOptions requestOptions) {
        return this.rawClient.checkApiKey(requestOptions).body();
    }

    public V2Client v2() {
        return this.v2Client.get();
    }

    public EmbedJobsClient embedJobs() {
        return this.embedJobsClient.get();
    }

    public DatasetsClient datasets() {
        return this.datasetsClient.get();
    }

    public ConnectorsClient connectors() {
        return this.connectorsClient.get();
    }

    public ModelsClient models() {
        return this.modelsClient.get();
    }

    public FinetuningClient finetuning() {
        return this.finetuningClient.get();
    }

    public static CohereBuilder builder() {
        return new CohereBuilder();
    }
}

