/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api;

import com.cohere.api.Cohere;
import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.Environment;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class CohereBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private String token = System.getenv("CO_API_KEY");
    private String clientName = null;
    private Environment environment = Environment.PRODUCTION;
    private OkHttpClient httpClient;

    public CohereBuilder token(String token) {
        this.token = token;
        return this;
    }

    public CohereBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public CohereBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public CohereBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public CohereBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public CohereBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public CohereBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setAuthentication(builder);
        this.setCustomHeaders(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setAuthentication(ClientOptions.Builder builder) {
        if (this.token != null) {
            builder.addHeader("Authorization", "Bearer " + this.token);
        }
    }

    protected void setCustomHeaders(ClientOptions.Builder builder) {
        if (this.clientName != null) {
            builder.addHeader("X-Client-Name", this.clientName);
        }
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public Cohere build() {
        if (this.token == null) {
            throw new RuntimeException("Please provide token or set the CO_API_KEY environment variable.");
        }
        this.validateConfiguration();
        return new Cohere(this.buildClientOptions());
    }
}

