/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatConnector;
import com.cohere.api.types.ChatRequestCitationQuality;
import com.cohere.api.types.ChatRequestPromptTruncation;
import com.cohere.api.types.ChatRequestSafetyMode;
import com.cohere.api.types.Message;
import com.cohere.api.types.ResponseFormat;
import com.cohere.api.types.Tool;
import com.cohere.api.types.ToolResult;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatRequest {
    private final Optional<String> accepts;
    private final Optional<Boolean> rawPrompting;
    private final String message;
    private final Optional<String> model;
    private final Optional<String> preamble;
    private final Optional<List<Message>> chatHistory;
    private final Optional<String> conversationId;
    private final Optional<ChatRequestPromptTruncation> promptTruncation;
    private final Optional<List<ChatConnector>> connectors;
    private final Optional<Boolean> searchQueriesOnly;
    private final Optional<List<Map<String, String>>> documents;
    private final Optional<ChatRequestCitationQuality> citationQuality;
    private final Optional<Float> temperature;
    private final Optional<Integer> maxTokens;
    private final Optional<Integer> maxInputTokens;
    private final Optional<Integer> k;
    private final Optional<Double> p;
    private final Optional<Integer> seed;
    private final Optional<List<String>> stopSequences;
    private final Optional<Double> frequencyPenalty;
    private final Optional<Double> presencePenalty;
    private final Optional<List<Tool>> tools;
    private final Optional<List<ToolResult>> toolResults;
    private final Optional<Boolean> forceSingleStep;
    private final Optional<ResponseFormat> responseFormat;
    private final Optional<ChatRequestSafetyMode> safetyMode;
    private final Map<String, Object> additionalProperties;

    private ChatRequest(Optional<String> accepts, Optional<Boolean> rawPrompting, String message, Optional<String> model, Optional<String> preamble, Optional<List<Message>> chatHistory, Optional<String> conversationId, Optional<ChatRequestPromptTruncation> promptTruncation, Optional<List<ChatConnector>> connectors, Optional<Boolean> searchQueriesOnly, Optional<List<Map<String, String>>> documents, Optional<ChatRequestCitationQuality> citationQuality, Optional<Float> temperature, Optional<Integer> maxTokens, Optional<Integer> maxInputTokens, Optional<Integer> k, Optional<Double> p, Optional<Integer> seed, Optional<List<String>> stopSequences, Optional<Double> frequencyPenalty, Optional<Double> presencePenalty, Optional<List<Tool>> tools, Optional<List<ToolResult>> toolResults, Optional<Boolean> forceSingleStep, Optional<ResponseFormat> responseFormat, Optional<ChatRequestSafetyMode> safetyMode, Map<String, Object> additionalProperties) {
        this.accepts = accepts;
        this.rawPrompting = rawPrompting;
        this.message = message;
        this.model = model;
        this.preamble = preamble;
        this.chatHistory = chatHistory;
        this.conversationId = conversationId;
        this.promptTruncation = promptTruncation;
        this.connectors = connectors;
        this.searchQueriesOnly = searchQueriesOnly;
        this.documents = documents;
        this.citationQuality = citationQuality;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.maxInputTokens = maxInputTokens;
        this.k = k;
        this.p = p;
        this.seed = seed;
        this.stopSequences = stopSequences;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.tools = tools;
        this.toolResults = toolResults;
        this.forceSingleStep = forceSingleStep;
        this.responseFormat = responseFormat;
        this.safetyMode = safetyMode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="Accepts")
    public Optional<String> getAccepts() {
        return this.accepts;
    }

    @JsonProperty(value="raw_prompting")
    public Optional<Boolean> getRawPrompting() {
        return this.rawPrompting;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="stream")
    public Boolean getStream() {
        return false;
    }

    @JsonProperty(value="preamble")
    public Optional<String> getPreamble() {
        return this.preamble;
    }

    @JsonProperty(value="chat_history")
    public Optional<List<Message>> getChatHistory() {
        return this.chatHistory;
    }

    @JsonProperty(value="conversation_id")
    public Optional<String> getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="prompt_truncation")
    public Optional<ChatRequestPromptTruncation> getPromptTruncation() {
        return this.promptTruncation;
    }

    @JsonProperty(value="connectors")
    public Optional<List<ChatConnector>> getConnectors() {
        return this.connectors;
    }

    @JsonProperty(value="search_queries_only")
    public Optional<Boolean> getSearchQueriesOnly() {
        return this.searchQueriesOnly;
    }

    @JsonProperty(value="documents")
    public Optional<List<Map<String, String>>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="citation_quality")
    public Optional<ChatRequestCitationQuality> getCitationQuality() {
        return this.citationQuality;
    }

    @JsonProperty(value="temperature")
    public Optional<Float> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="max_tokens")
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="max_input_tokens")
    public Optional<Integer> getMaxInputTokens() {
        return this.maxInputTokens;
    }

    @JsonProperty(value="k")
    public Optional<Integer> getK() {
        return this.k;
    }

    @JsonProperty(value="p")
    public Optional<Double> getP() {
        return this.p;
    }

    @JsonProperty(value="seed")
    public Optional<Integer> getSeed() {
        return this.seed;
    }

    @JsonProperty(value="stop_sequences")
    public Optional<List<String>> getStopSequences() {
        return this.stopSequences;
    }

    @JsonProperty(value="frequency_penalty")
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="tools")
    public Optional<List<Tool>> getTools() {
        return this.tools;
    }

    @JsonProperty(value="tool_results")
    public Optional<List<ToolResult>> getToolResults() {
        return this.toolResults;
    }

    @JsonProperty(value="force_single_step")
    public Optional<Boolean> getForceSingleStep() {
        return this.forceSingleStep;
    }

    @JsonProperty(value="response_format")
    public Optional<ResponseFormat> getResponseFormat() {
        return this.responseFormat;
    }

    @JsonProperty(value="safety_mode")
    public Optional<ChatRequestSafetyMode> getSafetyMode() {
        return this.safetyMode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatRequest && this.equalTo((ChatRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatRequest other) {
        return this.accepts.equals(other.accepts) && this.rawPrompting.equals(other.rawPrompting) && this.message.equals(other.message) && this.model.equals(other.model) && this.preamble.equals(other.preamble) && this.chatHistory.equals(other.chatHistory) && this.conversationId.equals(other.conversationId) && this.promptTruncation.equals(other.promptTruncation) && this.connectors.equals(other.connectors) && this.searchQueriesOnly.equals(other.searchQueriesOnly) && this.documents.equals(other.documents) && this.citationQuality.equals(other.citationQuality) && this.temperature.equals(other.temperature) && this.maxTokens.equals(other.maxTokens) && this.maxInputTokens.equals(other.maxInputTokens) && this.k.equals(other.k) && this.p.equals(other.p) && this.seed.equals(other.seed) && this.stopSequences.equals(other.stopSequences) && this.frequencyPenalty.equals(other.frequencyPenalty) && this.presencePenalty.equals(other.presencePenalty) && this.tools.equals(other.tools) && this.toolResults.equals(other.toolResults) && this.forceSingleStep.equals(other.forceSingleStep) && this.responseFormat.equals(other.responseFormat) && this.safetyMode.equals(other.safetyMode);
    }

    public int hashCode() {
        return Objects.hash(this.accepts, this.rawPrompting, this.message, this.model, this.preamble, this.chatHistory, this.conversationId, this.promptTruncation, this.connectors, this.searchQueriesOnly, this.documents, this.citationQuality, this.temperature, this.maxTokens, this.maxInputTokens, this.k, this.p, this.seed, this.stopSequences, this.frequencyPenalty, this.presencePenalty, this.tools, this.toolResults, this.forceSingleStep, this.responseFormat, this.safetyMode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageStage,
    _FinalStage {
        private String message;
        private Optional<ChatRequestSafetyMode> safetyMode = Optional.empty();
        private Optional<ResponseFormat> responseFormat = Optional.empty();
        private Optional<Boolean> forceSingleStep = Optional.empty();
        private Optional<List<ToolResult>> toolResults = Optional.empty();
        private Optional<List<Tool>> tools = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private Optional<List<String>> stopSequences = Optional.empty();
        private Optional<Integer> seed = Optional.empty();
        private Optional<Double> p = Optional.empty();
        private Optional<Integer> k = Optional.empty();
        private Optional<Integer> maxInputTokens = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Float> temperature = Optional.empty();
        private Optional<ChatRequestCitationQuality> citationQuality = Optional.empty();
        private Optional<List<Map<String, String>>> documents = Optional.empty();
        private Optional<Boolean> searchQueriesOnly = Optional.empty();
        private Optional<List<ChatConnector>> connectors = Optional.empty();
        private Optional<ChatRequestPromptTruncation> promptTruncation = Optional.empty();
        private Optional<String> conversationId = Optional.empty();
        private Optional<List<Message>> chatHistory = Optional.empty();
        private Optional<String> preamble = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<Boolean> rawPrompting = Optional.empty();
        private Optional<String> accepts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatRequest other) {
            this.accepts(other.getAccepts());
            this.rawPrompting(other.getRawPrompting());
            this.message(other.getMessage());
            this.model(other.getModel());
            this.preamble(other.getPreamble());
            this.chatHistory(other.getChatHistory());
            this.conversationId(other.getConversationId());
            this.promptTruncation(other.getPromptTruncation());
            this.connectors(other.getConnectors());
            this.searchQueriesOnly(other.getSearchQueriesOnly());
            this.documents(other.getDocuments());
            this.citationQuality(other.getCitationQuality());
            this.temperature(other.getTemperature());
            this.maxTokens(other.getMaxTokens());
            this.maxInputTokens(other.getMaxInputTokens());
            this.k(other.getK());
            this.p(other.getP());
            this.seed(other.getSeed());
            this.stopSequences(other.getStopSequences());
            this.frequencyPenalty(other.getFrequencyPenalty());
            this.presencePenalty(other.getPresencePenalty());
            this.tools(other.getTools());
            this.toolResults(other.getToolResults());
            this.forceSingleStep(other.getForceSingleStep());
            this.responseFormat(other.getResponseFormat());
            this.safetyMode(other.getSafetyMode());
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(@NotNull String message) {
            this.message = Objects.requireNonNull(message, "message must not be null");
            return this;
        }

        @Override
        public _FinalStage safetyMode(ChatRequestSafetyMode safetyMode) {
            this.safetyMode = Optional.ofNullable(safetyMode);
            return this;
        }

        @Override
        @JsonSetter(value="safety_mode", nulls=Nulls.SKIP)
        public _FinalStage safetyMode(Optional<ChatRequestSafetyMode> safetyMode) {
            this.safetyMode = safetyMode;
            return this;
        }

        @Override
        public _FinalStage responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = Optional.ofNullable(responseFormat);
            return this;
        }

        @Override
        @JsonSetter(value="response_format", nulls=Nulls.SKIP)
        public _FinalStage responseFormat(Optional<ResponseFormat> responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Override
        public _FinalStage forceSingleStep(Boolean forceSingleStep) {
            this.forceSingleStep = Optional.ofNullable(forceSingleStep);
            return this;
        }

        @Override
        @JsonSetter(value="force_single_step", nulls=Nulls.SKIP)
        public _FinalStage forceSingleStep(Optional<Boolean> forceSingleStep) {
            this.forceSingleStep = forceSingleStep;
            return this;
        }

        @Override
        public _FinalStage toolResults(List<ToolResult> toolResults) {
            this.toolResults = Optional.ofNullable(toolResults);
            return this;
        }

        @Override
        @JsonSetter(value="tool_results", nulls=Nulls.SKIP)
        public _FinalStage toolResults(Optional<List<ToolResult>> toolResults) {
            this.toolResults = toolResults;
            return this;
        }

        @Override
        public _FinalStage tools(List<Tool> tools) {
            this.tools = Optional.ofNullable(tools);
            return this;
        }

        @Override
        @JsonSetter(value="tools", nulls=Nulls.SKIP)
        public _FinalStage tools(Optional<List<Tool>> tools) {
            this.tools = tools;
            return this;
        }

        @Override
        public _FinalStage presencePenalty(Double presencePenalty) {
            this.presencePenalty = Optional.ofNullable(presencePenalty);
            return this;
        }

        @Override
        @JsonSetter(value="presence_penalty", nulls=Nulls.SKIP)
        public _FinalStage presencePenalty(Optional<Double> presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Override
        public _FinalStage frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = Optional.ofNullable(frequencyPenalty);
            return this;
        }

        @Override
        @JsonSetter(value="frequency_penalty", nulls=Nulls.SKIP)
        public _FinalStage frequencyPenalty(Optional<Double> frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Override
        public _FinalStage stopSequences(List<String> stopSequences) {
            this.stopSequences = Optional.ofNullable(stopSequences);
            return this;
        }

        @Override
        @JsonSetter(value="stop_sequences", nulls=Nulls.SKIP)
        public _FinalStage stopSequences(Optional<List<String>> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public _FinalStage seed(Integer seed) {
            this.seed = Optional.ofNullable(seed);
            return this;
        }

        @Override
        @JsonSetter(value="seed", nulls=Nulls.SKIP)
        public _FinalStage seed(Optional<Integer> seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public _FinalStage p(Double p) {
            this.p = Optional.ofNullable(p);
            return this;
        }

        @Override
        @JsonSetter(value="p", nulls=Nulls.SKIP)
        public _FinalStage p(Optional<Double> p) {
            this.p = p;
            return this;
        }

        @Override
        public _FinalStage k(Integer k) {
            this.k = Optional.ofNullable(k);
            return this;
        }

        @Override
        @JsonSetter(value="k", nulls=Nulls.SKIP)
        public _FinalStage k(Optional<Integer> k) {
            this.k = k;
            return this;
        }

        @Override
        public _FinalStage maxInputTokens(Integer maxInputTokens) {
            this.maxInputTokens = Optional.ofNullable(maxInputTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_input_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxInputTokens(Optional<Integer> maxInputTokens) {
            this.maxInputTokens = maxInputTokens;
            return this;
        }

        @Override
        public _FinalStage maxTokens(Integer maxTokens) {
            this.maxTokens = Optional.ofNullable(maxTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxTokens(Optional<Integer> maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public _FinalStage temperature(Float temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Float> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage citationQuality(ChatRequestCitationQuality citationQuality) {
            this.citationQuality = Optional.ofNullable(citationQuality);
            return this;
        }

        @Override
        @JsonSetter(value="citation_quality", nulls=Nulls.SKIP)
        public _FinalStage citationQuality(Optional<ChatRequestCitationQuality> citationQuality) {
            this.citationQuality = citationQuality;
            return this;
        }

        @Override
        public _FinalStage documents(List<Map<String, String>> documents) {
            this.documents = Optional.ofNullable(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<Map<String, String>>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage searchQueriesOnly(Boolean searchQueriesOnly) {
            this.searchQueriesOnly = Optional.ofNullable(searchQueriesOnly);
            return this;
        }

        @Override
        @JsonSetter(value="search_queries_only", nulls=Nulls.SKIP)
        public _FinalStage searchQueriesOnly(Optional<Boolean> searchQueriesOnly) {
            this.searchQueriesOnly = searchQueriesOnly;
            return this;
        }

        @Override
        public _FinalStage connectors(List<ChatConnector> connectors) {
            this.connectors = Optional.ofNullable(connectors);
            return this;
        }

        @Override
        @JsonSetter(value="connectors", nulls=Nulls.SKIP)
        public _FinalStage connectors(Optional<List<ChatConnector>> connectors) {
            this.connectors = connectors;
            return this;
        }

        @Override
        public _FinalStage promptTruncation(ChatRequestPromptTruncation promptTruncation) {
            this.promptTruncation = Optional.ofNullable(promptTruncation);
            return this;
        }

        @Override
        @JsonSetter(value="prompt_truncation", nulls=Nulls.SKIP)
        public _FinalStage promptTruncation(Optional<ChatRequestPromptTruncation> promptTruncation) {
            this.promptTruncation = promptTruncation;
            return this;
        }

        @Override
        public _FinalStage conversationId(String conversationId) {
            this.conversationId = Optional.ofNullable(conversationId);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id", nulls=Nulls.SKIP)
        public _FinalStage conversationId(Optional<String> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Override
        public _FinalStage chatHistory(List<Message> chatHistory) {
            this.chatHistory = Optional.ofNullable(chatHistory);
            return this;
        }

        @Override
        @JsonSetter(value="chat_history", nulls=Nulls.SKIP)
        public _FinalStage chatHistory(Optional<List<Message>> chatHistory) {
            this.chatHistory = chatHistory;
            return this;
        }

        @Override
        public _FinalStage preamble(String preamble) {
            this.preamble = Optional.ofNullable(preamble);
            return this;
        }

        @Override
        @JsonSetter(value="preamble", nulls=Nulls.SKIP)
        public _FinalStage preamble(Optional<String> preamble) {
            this.preamble = preamble;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage rawPrompting(Boolean rawPrompting) {
            this.rawPrompting = Optional.ofNullable(rawPrompting);
            return this;
        }

        @Override
        @JsonSetter(value="raw_prompting", nulls=Nulls.SKIP)
        public _FinalStage rawPrompting(Optional<Boolean> rawPrompting) {
            this.rawPrompting = rawPrompting;
            return this;
        }

        @Override
        public _FinalStage accepts(String accepts) {
            this.accepts = Optional.ofNullable(accepts);
            return this;
        }

        @Override
        @JsonSetter(value="Accepts", nulls=Nulls.SKIP)
        public _FinalStage accepts(Optional<String> accepts) {
            this.accepts = accepts;
            return this;
        }

        @Override
        public ChatRequest build() {
            return new ChatRequest(this.accepts, this.rawPrompting, this.message, this.model, this.preamble, this.chatHistory, this.conversationId, this.promptTruncation, this.connectors, this.searchQueriesOnly, this.documents, this.citationQuality, this.temperature, this.maxTokens, this.maxInputTokens, this.k, this.p, this.seed, this.stopSequences, this.frequencyPenalty, this.presencePenalty, this.tools, this.toolResults, this.forceSingleStep, this.responseFormat, this.safetyMode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatRequest build();

        public _FinalStage accepts(Optional<String> var1);

        public _FinalStage accepts(String var1);

        public _FinalStage rawPrompting(Optional<Boolean> var1);

        public _FinalStage rawPrompting(Boolean var1);

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage preamble(Optional<String> var1);

        public _FinalStage preamble(String var1);

        public _FinalStage chatHistory(Optional<List<Message>> var1);

        public _FinalStage chatHistory(List<Message> var1);

        public _FinalStage conversationId(Optional<String> var1);

        public _FinalStage conversationId(String var1);

        public _FinalStage promptTruncation(Optional<ChatRequestPromptTruncation> var1);

        public _FinalStage promptTruncation(ChatRequestPromptTruncation var1);

        public _FinalStage connectors(Optional<List<ChatConnector>> var1);

        public _FinalStage connectors(List<ChatConnector> var1);

        public _FinalStage searchQueriesOnly(Optional<Boolean> var1);

        public _FinalStage searchQueriesOnly(Boolean var1);

        public _FinalStage documents(Optional<List<Map<String, String>>> var1);

        public _FinalStage documents(List<Map<String, String>> var1);

        public _FinalStage citationQuality(Optional<ChatRequestCitationQuality> var1);

        public _FinalStage citationQuality(ChatRequestCitationQuality var1);

        public _FinalStage temperature(Optional<Float> var1);

        public _FinalStage temperature(Float var1);

        public _FinalStage maxTokens(Optional<Integer> var1);

        public _FinalStage maxTokens(Integer var1);

        public _FinalStage maxInputTokens(Optional<Integer> var1);

        public _FinalStage maxInputTokens(Integer var1);

        public _FinalStage k(Optional<Integer> var1);

        public _FinalStage k(Integer var1);

        public _FinalStage p(Optional<Double> var1);

        public _FinalStage p(Double var1);

        public _FinalStage seed(Optional<Integer> var1);

        public _FinalStage seed(Integer var1);

        public _FinalStage stopSequences(Optional<List<String>> var1);

        public _FinalStage stopSequences(List<String> var1);

        public _FinalStage frequencyPenalty(Optional<Double> var1);

        public _FinalStage frequencyPenalty(Double var1);

        public _FinalStage presencePenalty(Optional<Double> var1);

        public _FinalStage presencePenalty(Double var1);

        public _FinalStage tools(Optional<List<Tool>> var1);

        public _FinalStage tools(List<Tool> var1);

        public _FinalStage toolResults(Optional<List<ToolResult>> var1);

        public _FinalStage toolResults(List<ToolResult> var1);

        public _FinalStage forceSingleStep(Optional<Boolean> var1);

        public _FinalStage forceSingleStep(Boolean var1);

        public _FinalStage responseFormat(Optional<ResponseFormat> var1);

        public _FinalStage responseFormat(ResponseFormat var1);

        public _FinalStage safetyMode(Optional<ChatRequestSafetyMode> var1);

        public _FinalStage safetyMode(ChatRequestSafetyMode var1);
    }

    public static interface MessageStage {
        public _FinalStage message(@NotNull String var1);

        public Builder from(ChatRequest var1);
    }
}

