/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ClassifyExample;
import com.cohere.api.types.ClassifyRequestTruncate;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyRequest {
    private final List<String> inputs;
    private final Optional<List<ClassifyExample>> examples;
    private final Optional<String> model;
    private final Optional<String> preset;
    private final Optional<ClassifyRequestTruncate> truncate;
    private final Map<String, Object> additionalProperties;

    private ClassifyRequest(List<String> inputs, Optional<List<ClassifyExample>> examples, Optional<String> model, Optional<String> preset, Optional<ClassifyRequestTruncate> truncate, Map<String, Object> additionalProperties) {
        this.inputs = inputs;
        this.examples = examples;
        this.model = model;
        this.preset = preset;
        this.truncate = truncate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="inputs")
    public List<String> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="examples")
    public Optional<List<ClassifyExample>> getExamples() {
        return this.examples;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="preset")
    public Optional<String> getPreset() {
        return this.preset;
    }

    @JsonProperty(value="truncate")
    public Optional<ClassifyRequestTruncate> getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyRequest && this.equalTo((ClassifyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClassifyRequest other) {
        return this.inputs.equals(other.inputs) && this.examples.equals(other.examples) && this.model.equals(other.model) && this.preset.equals(other.preset) && this.truncate.equals(other.truncate);
    }

    public int hashCode() {
        return Objects.hash(this.inputs, this.examples, this.model, this.preset, this.truncate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> inputs = new ArrayList<String>();
        private Optional<List<ClassifyExample>> examples = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<String> preset = Optional.empty();
        private Optional<ClassifyRequestTruncate> truncate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ClassifyRequest other) {
            this.inputs(other.getInputs());
            this.examples(other.getExamples());
            this.model(other.getModel());
            this.preset(other.getPreset());
            this.truncate(other.getTruncate());
            return this;
        }

        @JsonSetter(value="inputs", nulls=Nulls.SKIP)
        public Builder inputs(List<String> inputs) {
            this.inputs.clear();
            this.inputs.addAll(inputs);
            return this;
        }

        public Builder addInputs(String inputs) {
            this.inputs.add(inputs);
            return this;
        }

        public Builder addAllInputs(List<String> inputs) {
            this.inputs.addAll(inputs);
            return this;
        }

        @JsonSetter(value="examples", nulls=Nulls.SKIP)
        public Builder examples(Optional<List<ClassifyExample>> examples) {
            this.examples = examples;
            return this;
        }

        public Builder examples(List<ClassifyExample> examples) {
            this.examples = Optional.ofNullable(examples);
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<String> model) {
            this.model = model;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @JsonSetter(value="preset", nulls=Nulls.SKIP)
        public Builder preset(Optional<String> preset) {
            this.preset = preset;
            return this;
        }

        public Builder preset(String preset) {
            this.preset = Optional.ofNullable(preset);
            return this;
        }

        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public Builder truncate(Optional<ClassifyRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        public Builder truncate(ClassifyRequestTruncate truncate) {
            this.truncate = Optional.ofNullable(truncate);
            return this;
        }

        public ClassifyRequest build() {
            return new ClassifyRequest(this.inputs, this.examples, this.model, this.preset, this.truncate, this.additionalProperties);
        }
    }
}

