/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.EmbedInputType;
import com.cohere.api.types.EmbedRequestTruncate;
import com.cohere.api.types.EmbeddingType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmbedRequest {
    private final Optional<List<String>> texts;
    private final Optional<List<String>> images;
    private final Optional<String> model;
    private final Optional<EmbedInputType> inputType;
    private final Optional<List<EmbeddingType>> embeddingTypes;
    private final Optional<EmbedRequestTruncate> truncate;
    private final Map<String, Object> additionalProperties;

    private EmbedRequest(Optional<List<String>> texts, Optional<List<String>> images, Optional<String> model, Optional<EmbedInputType> inputType, Optional<List<EmbeddingType>> embeddingTypes, Optional<EmbedRequestTruncate> truncate, Map<String, Object> additionalProperties) {
        this.texts = texts;
        this.images = images;
        this.model = model;
        this.inputType = inputType;
        this.embeddingTypes = embeddingTypes;
        this.truncate = truncate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="texts")
    public Optional<List<String>> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="images")
    public Optional<List<String>> getImages() {
        return this.images;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="input_type")
    public Optional<EmbedInputType> getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="embedding_types")
    public Optional<List<EmbeddingType>> getEmbeddingTypes() {
        return this.embeddingTypes;
    }

    @JsonProperty(value="truncate")
    public Optional<EmbedRequestTruncate> getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedRequest && this.equalTo((EmbedRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmbedRequest other) {
        return this.texts.equals(other.texts) && this.images.equals(other.images) && this.model.equals(other.model) && this.inputType.equals(other.inputType) && this.embeddingTypes.equals(other.embeddingTypes) && this.truncate.equals(other.truncate);
    }

    public int hashCode() {
        return Objects.hash(this.texts, this.images, this.model, this.inputType, this.embeddingTypes, this.truncate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> texts = Optional.empty();
        private Optional<List<String>> images = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<EmbedInputType> inputType = Optional.empty();
        private Optional<List<EmbeddingType>> embeddingTypes = Optional.empty();
        private Optional<EmbedRequestTruncate> truncate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmbedRequest other) {
            this.texts(other.getTexts());
            this.images(other.getImages());
            this.model(other.getModel());
            this.inputType(other.getInputType());
            this.embeddingTypes(other.getEmbeddingTypes());
            this.truncate(other.getTruncate());
            return this;
        }

        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public Builder texts(Optional<List<String>> texts) {
            this.texts = texts;
            return this;
        }

        public Builder texts(List<String> texts) {
            this.texts = Optional.ofNullable(texts);
            return this;
        }

        @JsonSetter(value="images", nulls=Nulls.SKIP)
        public Builder images(Optional<List<String>> images) {
            this.images = images;
            return this;
        }

        public Builder images(List<String> images) {
            this.images = Optional.ofNullable(images);
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<String> model) {
            this.model = model;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @JsonSetter(value="input_type", nulls=Nulls.SKIP)
        public Builder inputType(Optional<EmbedInputType> inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder inputType(EmbedInputType inputType) {
            this.inputType = Optional.ofNullable(inputType);
            return this;
        }

        @JsonSetter(value="embedding_types", nulls=Nulls.SKIP)
        public Builder embeddingTypes(Optional<List<EmbeddingType>> embeddingTypes) {
            this.embeddingTypes = embeddingTypes;
            return this;
        }

        public Builder embeddingTypes(List<EmbeddingType> embeddingTypes) {
            this.embeddingTypes = Optional.ofNullable(embeddingTypes);
            return this;
        }

        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public Builder truncate(Optional<EmbedRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        public Builder truncate(EmbedRequestTruncate truncate) {
            this.truncate = Optional.ofNullable(truncate);
            return this;
        }

        public EmbedRequest build() {
            return new EmbedRequest(this.texts, this.images, this.model, this.inputType, this.embeddingTypes, this.truncate, this.additionalProperties);
        }
    }
}

