/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.connectors;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.connectors.AsyncRawConnectorsClient;
import com.cohere.api.resources.connectors.requests.ConnectorsListRequest;
import com.cohere.api.resources.connectors.requests.ConnectorsOAuthAuthorizeRequest;
import com.cohere.api.resources.connectors.requests.CreateConnectorRequest;
import com.cohere.api.resources.connectors.requests.UpdateConnectorRequest;
import com.cohere.api.types.CreateConnectorResponse;
import com.cohere.api.types.GetConnectorResponse;
import com.cohere.api.types.ListConnectorsResponse;
import com.cohere.api.types.OAuthAuthorizeResponse;
import com.cohere.api.types.UpdateConnectorResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncConnectorsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawConnectorsClient rawClient;

    public AsyncConnectorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConnectorsClient(clientOptions);
    }

    public AsyncRawConnectorsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListConnectorsResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListConnectorsResponse)response.body());
    }

    public CompletableFuture<ListConnectorsResponse> list(ConnectorsListRequest request) {
        return this.rawClient.list(request).thenApply(response -> (ListConnectorsResponse)response.body());
    }

    public CompletableFuture<ListConnectorsResponse> list(ConnectorsListRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (ListConnectorsResponse)response.body());
    }

    public CompletableFuture<CreateConnectorResponse> create(CreateConnectorRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateConnectorResponse)response.body());
    }

    public CompletableFuture<CreateConnectorResponse> create(CreateConnectorRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateConnectorResponse)response.body());
    }

    public CompletableFuture<GetConnectorResponse> get(String id) {
        return this.rawClient.get(id).thenApply(response -> (GetConnectorResponse)response.body());
    }

    public CompletableFuture<GetConnectorResponse> get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).thenApply(response -> (GetConnectorResponse)response.body());
    }

    public CompletableFuture<Map<String, Object>> delete(String id) {
        return this.rawClient.delete(id).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> delete(String id, RequestOptions requestOptions) {
        return this.rawClient.delete(id, requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<UpdateConnectorResponse> update(String id) {
        return this.rawClient.update(id).thenApply(response -> (UpdateConnectorResponse)response.body());
    }

    public CompletableFuture<UpdateConnectorResponse> update(String id, UpdateConnectorRequest request) {
        return this.rawClient.update(id, request).thenApply(response -> (UpdateConnectorResponse)response.body());
    }

    public CompletableFuture<UpdateConnectorResponse> update(String id, UpdateConnectorRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(id, request, requestOptions).thenApply(response -> (UpdateConnectorResponse)response.body());
    }

    public CompletableFuture<OAuthAuthorizeResponse> oAuthAuthorize(String id) {
        return this.rawClient.oAuthAuthorize(id).thenApply(response -> (OAuthAuthorizeResponse)response.body());
    }

    public CompletableFuture<OAuthAuthorizeResponse> oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request) {
        return this.rawClient.oAuthAuthorize(id, request).thenApply(response -> (OAuthAuthorizeResponse)response.body());
    }

    public CompletableFuture<OAuthAuthorizeResponse> oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.oAuthAuthorize(id, request, requestOptions).thenApply(response -> (OAuthAuthorizeResponse)response.body());
    }
}

