/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.datasets.AsyncRawDatasetsClient;
import com.cohere.api.resources.datasets.requests.DatasetsCreateRequest;
import com.cohere.api.resources.datasets.requests.DatasetsListRequest;
import com.cohere.api.resources.datasets.types.DatasetsCreateResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetUsageResponse;
import com.cohere.api.resources.datasets.types.DatasetsListResponse;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncDatasetsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDatasetsClient rawClient;

    public AsyncDatasetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDatasetsClient(clientOptions);
    }

    public AsyncRawDatasetsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DatasetsListResponse> list() {
        return this.rawClient.list().thenApply(response -> (DatasetsListResponse)response.body());
    }

    public CompletableFuture<DatasetsListResponse> list(DatasetsListRequest request) {
        return this.rawClient.list(request).thenApply(response -> (DatasetsListResponse)response.body());
    }

    public CompletableFuture<DatasetsListResponse> list(DatasetsListRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (DatasetsListResponse)response.body());
    }

    public CompletableFuture<DatasetsCreateResponse> create(File data, Optional<File> evalData, DatasetsCreateRequest request) {
        return this.rawClient.create(data, evalData, request).thenApply(response -> (DatasetsCreateResponse)response.body());
    }

    public CompletableFuture<DatasetsCreateResponse> create(File data, Optional<File> evalData, DatasetsCreateRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(data, evalData, request, requestOptions).thenApply(response -> (DatasetsCreateResponse)response.body());
    }

    public CompletableFuture<DatasetsGetUsageResponse> getUsage() {
        return this.rawClient.getUsage().thenApply(response -> (DatasetsGetUsageResponse)response.body());
    }

    public CompletableFuture<DatasetsGetUsageResponse> getUsage(RequestOptions requestOptions) {
        return this.rawClient.getUsage(requestOptions).thenApply(response -> (DatasetsGetUsageResponse)response.body());
    }

    public CompletableFuture<DatasetsGetResponse> get(String id) {
        return this.rawClient.get(id).thenApply(response -> (DatasetsGetResponse)response.body());
    }

    public CompletableFuture<DatasetsGetResponse> get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).thenApply(response -> (DatasetsGetResponse)response.body());
    }

    public CompletableFuture<Map<String, Object>> delete(String id) {
        return this.rawClient.delete(id).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> delete(String id, RequestOptions requestOptions) {
        return this.rawClient.delete(id, requestOptions).thenApply(response -> (Map)response.body());
    }
}

