/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.embedjobs;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.embedjobs.AsyncRawEmbedJobsClient;
import com.cohere.api.resources.embedjobs.requests.CreateEmbedJobRequest;
import com.cohere.api.types.CreateEmbedJobResponse;
import com.cohere.api.types.EmbedJob;
import com.cohere.api.types.ListEmbedJobResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncEmbedJobsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEmbedJobsClient rawClient;

    public AsyncEmbedJobsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEmbedJobsClient(clientOptions);
    }

    public AsyncRawEmbedJobsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListEmbedJobResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListEmbedJobResponse)response.body());
    }

    public CompletableFuture<ListEmbedJobResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (ListEmbedJobResponse)response.body());
    }

    public CompletableFuture<CreateEmbedJobResponse> create(CreateEmbedJobRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateEmbedJobResponse)response.body());
    }

    public CompletableFuture<CreateEmbedJobResponse> create(CreateEmbedJobRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateEmbedJobResponse)response.body());
    }

    public CompletableFuture<EmbedJob> get(String id) {
        return this.rawClient.get(id).thenApply(response -> (EmbedJob)response.body());
    }

    public CompletableFuture<EmbedJob> get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).thenApply(response -> (EmbedJob)response.body());
    }

    public CompletableFuture<Void> cancel(String id) {
        return this.rawClient.cancel(id).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> cancel(String id, RequestOptions requestOptions) {
        return this.rawClient.cancel(id, requestOptions).thenApply(response -> (Void)response.body());
    }
}

