/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.finetuning.AsyncRawFinetuningClient;
import com.cohere.api.resources.finetuning.finetuning.types.CreateFinetunedModelResponse;
import com.cohere.api.resources.finetuning.finetuning.types.FinetunedModel;
import com.cohere.api.resources.finetuning.finetuning.types.GetFinetunedModelResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListEventsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListFinetunedModelsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListTrainingStepMetricsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.UpdateFinetunedModelResponse;
import com.cohere.api.resources.finetuning.requests.FinetuningListEventsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningListFinetunedModelsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningListTrainingStepMetricsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningUpdateFinetunedModelRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncFinetuningClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFinetuningClient rawClient;

    public AsyncFinetuningClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFinetuningClient(clientOptions);
    }

    public AsyncRawFinetuningClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListFinetunedModelsResponse> listFinetunedModels() {
        return this.rawClient.listFinetunedModels().thenApply(response -> (ListFinetunedModelsResponse)response.body());
    }

    public CompletableFuture<ListFinetunedModelsResponse> listFinetunedModels(FinetuningListFinetunedModelsRequest request) {
        return this.rawClient.listFinetunedModels(request).thenApply(response -> (ListFinetunedModelsResponse)response.body());
    }

    public CompletableFuture<ListFinetunedModelsResponse> listFinetunedModels(FinetuningListFinetunedModelsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFinetunedModels(request, requestOptions).thenApply(response -> (ListFinetunedModelsResponse)response.body());
    }

    public CompletableFuture<CreateFinetunedModelResponse> createFinetunedModel(FinetunedModel request) {
        return this.rawClient.createFinetunedModel(request).thenApply(response -> (CreateFinetunedModelResponse)response.body());
    }

    public CompletableFuture<CreateFinetunedModelResponse> createFinetunedModel(FinetunedModel request, RequestOptions requestOptions) {
        return this.rawClient.createFinetunedModel(request, requestOptions).thenApply(response -> (CreateFinetunedModelResponse)response.body());
    }

    public CompletableFuture<GetFinetunedModelResponse> getFinetunedModel(String id) {
        return this.rawClient.getFinetunedModel(id).thenApply(response -> (GetFinetunedModelResponse)response.body());
    }

    public CompletableFuture<GetFinetunedModelResponse> getFinetunedModel(String id, RequestOptions requestOptions) {
        return this.rawClient.getFinetunedModel(id, requestOptions).thenApply(response -> (GetFinetunedModelResponse)response.body());
    }

    public CompletableFuture<Map<String, Object>> deleteFinetunedModel(String id) {
        return this.rawClient.deleteFinetunedModel(id).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> deleteFinetunedModel(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteFinetunedModel(id, requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<UpdateFinetunedModelResponse> updateFinetunedModel(String id, FinetuningUpdateFinetunedModelRequest request) {
        return this.rawClient.updateFinetunedModel(id, request).thenApply(response -> (UpdateFinetunedModelResponse)response.body());
    }

    public CompletableFuture<UpdateFinetunedModelResponse> updateFinetunedModel(String id, FinetuningUpdateFinetunedModelRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateFinetunedModel(id, request, requestOptions).thenApply(response -> (UpdateFinetunedModelResponse)response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents(String finetunedModelId) {
        return this.rawClient.listEvents(finetunedModelId).thenApply(response -> (ListEventsResponse)response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents(String finetunedModelId, FinetuningListEventsRequest request) {
        return this.rawClient.listEvents(finetunedModelId, request).thenApply(response -> (ListEventsResponse)response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents(String finetunedModelId, FinetuningListEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEvents(finetunedModelId, request, requestOptions).thenApply(response -> (ListEventsResponse)response.body());
    }

    public CompletableFuture<ListTrainingStepMetricsResponse> listTrainingStepMetrics(String finetunedModelId) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId).thenApply(response -> (ListTrainingStepMetricsResponse)response.body());
    }

    public CompletableFuture<ListTrainingStepMetricsResponse> listTrainingStepMetrics(String finetunedModelId, FinetuningListTrainingStepMetricsRequest request) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId, request).thenApply(response -> (ListTrainingStepMetricsResponse)response.body());
    }

    public CompletableFuture<ListTrainingStepMetricsResponse> listTrainingStepMetrics(String finetunedModelId, FinetuningListTrainingStepMetricsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId, request, requestOptions).thenApply(response -> (ListTrainingStepMetricsResponse)response.body());
    }
}

