/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.Settings;
import com.cohere.api.resources.finetuning.finetuning.types.Status;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FinetunedModel {
    private final Optional<String> id;
    private final String name;
    private final Optional<String> creatorId;
    private final Optional<String> organizationId;
    private final Settings settings;
    private final Optional<Status> status;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> updatedAt;
    private final Optional<OffsetDateTime> completedAt;
    private final Optional<OffsetDateTime> lastUsed;
    private final Map<String, Object> additionalProperties;

    private FinetunedModel(Optional<String> id, String name, Optional<String> creatorId, Optional<String> organizationId, Settings settings, Optional<Status> status, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, Optional<OffsetDateTime> completedAt, Optional<OffsetDateTime> lastUsed, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.creatorId = creatorId;
        this.organizationId = organizationId;
        this.settings = settings;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.completedAt = completedAt;
        this.lastUsed = lastUsed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="creator_id")
    public Optional<String> getCreatorId() {
        return this.creatorId;
    }

    @JsonProperty(value="organization_id")
    public Optional<String> getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="settings")
    public Settings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="completed_at")
    public Optional<OffsetDateTime> getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="last_used")
    public Optional<OffsetDateTime> getLastUsed() {
        return this.lastUsed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FinetunedModel && this.equalTo((FinetunedModel)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FinetunedModel other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.creatorId.equals(other.creatorId) && this.organizationId.equals(other.organizationId) && this.settings.equals(other.settings) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.completedAt.equals(other.completedAt) && this.lastUsed.equals(other.lastUsed);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.creatorId, this.organizationId, this.settings, this.status, this.createdAt, this.updatedAt, this.completedAt, this.lastUsed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    SettingsStage,
    _FinalStage {
        private String name;
        private Settings settings;
        private Optional<OffsetDateTime> lastUsed = Optional.empty();
        private Optional<OffsetDateTime> completedAt = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<Status> status = Optional.empty();
        private Optional<String> organizationId = Optional.empty();
        private Optional<String> creatorId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FinetunedModel other) {
            this.id(other.getId());
            this.name(other.getName());
            this.creatorId(other.getCreatorId());
            this.organizationId(other.getOrganizationId());
            this.settings(other.getSettings());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.completedAt(other.getCompletedAt());
            this.lastUsed(other.getLastUsed());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public SettingsStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="settings")
        public _FinalStage settings(@NotNull Settings settings) {
            this.settings = Objects.requireNonNull(settings, "settings must not be null");
            return this;
        }

        @Override
        public _FinalStage lastUsed(OffsetDateTime lastUsed) {
            this.lastUsed = Optional.ofNullable(lastUsed);
            return this;
        }

        @Override
        @JsonSetter(value="last_used", nulls=Nulls.SKIP)
        public _FinalStage lastUsed(Optional<OffsetDateTime> lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }

        @Override
        public _FinalStage completedAt(OffsetDateTime completedAt) {
            this.completedAt = Optional.ofNullable(completedAt);
            return this;
        }

        @Override
        @JsonSetter(value="completed_at", nulls=Nulls.SKIP)
        public _FinalStage completedAt(Optional<OffsetDateTime> completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public _FinalStage updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage organizationId(String organizationId) {
            this.organizationId = Optional.ofNullable(organizationId);
            return this;
        }

        @Override
        @JsonSetter(value="organization_id", nulls=Nulls.SKIP)
        public _FinalStage organizationId(Optional<String> organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Override
        public _FinalStage creatorId(String creatorId) {
            this.creatorId = Optional.ofNullable(creatorId);
            return this;
        }

        @Override
        @JsonSetter(value="creator_id", nulls=Nulls.SKIP)
        public _FinalStage creatorId(Optional<String> creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public FinetunedModel build() {
            return new FinetunedModel(this.id, this.name, this.creatorId, this.organizationId, this.settings, this.status, this.createdAt, this.updatedAt, this.completedAt, this.lastUsed, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FinetunedModel build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage creatorId(Optional<String> var1);

        public _FinalStage creatorId(String var1);

        public _FinalStage organizationId(Optional<String> var1);

        public _FinalStage organizationId(String var1);

        public _FinalStage status(Optional<Status> var1);

        public _FinalStage status(Status var1);

        public _FinalStage createdAt(Optional<OffsetDateTime> var1);

        public _FinalStage createdAt(OffsetDateTime var1);

        public _FinalStage updatedAt(Optional<OffsetDateTime> var1);

        public _FinalStage updatedAt(OffsetDateTime var1);

        public _FinalStage completedAt(Optional<OffsetDateTime> var1);

        public _FinalStage completedAt(OffsetDateTime var1);

        public _FinalStage lastUsed(Optional<OffsetDateTime> var1);

        public _FinalStage lastUsed(OffsetDateTime var1);
    }

    public static interface SettingsStage {
        public _FinalStage settings(@NotNull Settings var1);
    }

    public static interface NameStage {
        public SettingsStage name(@NotNull String var1);

        public Builder from(FinetunedModel var1);
    }
}

