/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.FinetunedModel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListFinetunedModelsResponse {
    private final Optional<List<FinetunedModel>> finetunedModels;
    private final Optional<String> nextPageToken;
    private final Optional<Integer> totalSize;
    private final Map<String, Object> additionalProperties;

    private ListFinetunedModelsResponse(Optional<List<FinetunedModel>> finetunedModels, Optional<String> nextPageToken, Optional<Integer> totalSize, Map<String, Object> additionalProperties) {
        this.finetunedModels = finetunedModels;
        this.nextPageToken = nextPageToken;
        this.totalSize = totalSize;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="finetuned_models")
    public Optional<List<FinetunedModel>> getFinetunedModels() {
        return this.finetunedModels;
    }

    @JsonProperty(value="next_page_token")
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="total_size")
    public Optional<Integer> getTotalSize() {
        return this.totalSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListFinetunedModelsResponse && this.equalTo((ListFinetunedModelsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListFinetunedModelsResponse other) {
        return this.finetunedModels.equals(other.finetunedModels) && this.nextPageToken.equals(other.nextPageToken) && this.totalSize.equals(other.totalSize);
    }

    public int hashCode() {
        return Objects.hash(this.finetunedModels, this.nextPageToken, this.totalSize);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<FinetunedModel>> finetunedModels = Optional.empty();
        private Optional<String> nextPageToken = Optional.empty();
        private Optional<Integer> totalSize = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListFinetunedModelsResponse other) {
            this.finetunedModels(other.getFinetunedModels());
            this.nextPageToken(other.getNextPageToken());
            this.totalSize(other.getTotalSize());
            return this;
        }

        @JsonSetter(value="finetuned_models", nulls=Nulls.SKIP)
        public Builder finetunedModels(Optional<List<FinetunedModel>> finetunedModels) {
            this.finetunedModels = finetunedModels;
            return this;
        }

        public Builder finetunedModels(List<FinetunedModel> finetunedModels) {
            this.finetunedModels = Optional.ofNullable(finetunedModels);
            return this;
        }

        @JsonSetter(value="next_page_token", nulls=Nulls.SKIP)
        public Builder nextPageToken(Optional<String> nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = Optional.ofNullable(nextPageToken);
            return this;
        }

        @JsonSetter(value="total_size", nulls=Nulls.SKIP)
        public Builder totalSize(Optional<Integer> totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder totalSize(Integer totalSize) {
            this.totalSize = Optional.ofNullable(totalSize);
            return this;
        }

        public ListFinetunedModelsResponse build() {
            return new ListFinetunedModelsResponse(this.finetunedModels, this.nextPageToken, this.totalSize, this.additionalProperties);
        }
    }
}

