/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TrainingStepMetrics {
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<Integer> stepNumber;
    private final Optional<Map<String, Double>> metrics;
    private final Map<String, Object> additionalProperties;

    private TrainingStepMetrics(Optional<OffsetDateTime> createdAt, Optional<Integer> stepNumber, Optional<Map<String, Double>> metrics, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.stepNumber = stepNumber;
        this.metrics = metrics;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="step_number")
    public Optional<Integer> getStepNumber() {
        return this.stepNumber;
    }

    @JsonProperty(value="metrics")
    public Optional<Map<String, Double>> getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TrainingStepMetrics && this.equalTo((TrainingStepMetrics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TrainingStepMetrics other) {
        return this.createdAt.equals(other.createdAt) && this.stepNumber.equals(other.stepNumber) && this.metrics.equals(other.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.stepNumber, this.metrics);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<Integer> stepNumber = Optional.empty();
        private Optional<Map<String, Double>> metrics = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TrainingStepMetrics other) {
            this.createdAt(other.getCreatedAt());
            this.stepNumber(other.getStepNumber());
            this.metrics(other.getMetrics());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="step_number", nulls=Nulls.SKIP)
        public Builder stepNumber(Optional<Integer> stepNumber) {
            this.stepNumber = stepNumber;
            return this;
        }

        public Builder stepNumber(Integer stepNumber) {
            this.stepNumber = Optional.ofNullable(stepNumber);
            return this;
        }

        @JsonSetter(value="metrics", nulls=Nulls.SKIP)
        public Builder metrics(Optional<Map<String, Double>> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder metrics(Map<String, Double> metrics) {
            this.metrics = Optional.ofNullable(metrics);
            return this;
        }

        public TrainingStepMetrics build() {
            return new TrainingStepMetrics(this.createdAt, this.stepNumber, this.metrics, this.additionalProperties);
        }
    }
}

