/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.Settings;
import com.cohere.api.resources.finetuning.finetuning.types.Status;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FinetuningUpdateFinetunedModelRequest {
    private final String name;
    private final Settings settings;
    private final Optional<Status> status;
    private final Map<String, Object> additionalProperties;

    private FinetuningUpdateFinetunedModelRequest(String name, Settings settings, Optional<Status> status, Map<String, Object> additionalProperties) {
        this.name = name;
        this.settings = settings;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="settings")
    public Settings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FinetuningUpdateFinetunedModelRequest && this.equalTo((FinetuningUpdateFinetunedModelRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FinetuningUpdateFinetunedModelRequest other) {
        return this.name.equals(other.name) && this.settings.equals(other.settings) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.settings, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    SettingsStage,
    _FinalStage {
        private String name;
        private Settings settings;
        private Optional<Status> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FinetuningUpdateFinetunedModelRequest other) {
            this.name(other.getName());
            this.settings(other.getSettings());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public SettingsStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="settings")
        public _FinalStage settings(@NotNull Settings settings) {
            this.settings = Objects.requireNonNull(settings, "settings must not be null");
            return this;
        }

        @Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @Override
        public FinetuningUpdateFinetunedModelRequest build() {
            return new FinetuningUpdateFinetunedModelRequest(this.name, this.settings, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FinetuningUpdateFinetunedModelRequest build();

        public _FinalStage status(Optional<Status> var1);

        public _FinalStage status(Status var1);
    }

    public static interface SettingsStage {
        public _FinalStage settings(@NotNull Settings var1);
    }

    public static interface NameStage {
        public SettingsStage name(@NotNull String var1);

        public Builder from(FinetuningUpdateFinetunedModelRequest var1);
    }
}

