/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.v2.AsyncRawV2Client;
import com.cohere.api.resources.v2.requests.V2ChatRequest;
import com.cohere.api.resources.v2.requests.V2ChatStreamRequest;
import com.cohere.api.resources.v2.requests.V2EmbedRequest;
import com.cohere.api.resources.v2.requests.V2RerankRequest;
import com.cohere.api.resources.v2.types.V2ChatResponse;
import com.cohere.api.resources.v2.types.V2ChatStreamResponse;
import com.cohere.api.resources.v2.types.V2RerankResponse;
import com.cohere.api.types.EmbedByTypeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncV2Client {
    protected final ClientOptions clientOptions;
    private final AsyncRawV2Client rawClient;

    public AsyncV2Client(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawV2Client(clientOptions);
    }

    public AsyncRawV2Client withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Iterable<V2ChatStreamResponse>> chatStream(V2ChatStreamRequest request) {
        return this.rawClient.chatStream(request).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<Iterable<V2ChatStreamResponse>> chatStream(V2ChatStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.chatStream(request, requestOptions).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<V2ChatResponse> chat(V2ChatRequest request) {
        return this.rawClient.chat(request).thenApply(response -> (V2ChatResponse)response.body());
    }

    public CompletableFuture<V2ChatResponse> chat(V2ChatRequest request, RequestOptions requestOptions) {
        return this.rawClient.chat(request, requestOptions).thenApply(response -> (V2ChatResponse)response.body());
    }

    public CompletableFuture<EmbedByTypeResponse> embed(V2EmbedRequest request) {
        return this.rawClient.embed(request).thenApply(response -> (EmbedByTypeResponse)response.body());
    }

    public CompletableFuture<EmbedByTypeResponse> embed(V2EmbedRequest request, RequestOptions requestOptions) {
        return this.rawClient.embed(request, requestOptions).thenApply(response -> (EmbedByTypeResponse)response.body());
    }

    public CompletableFuture<V2RerankResponse> rerank(V2RerankRequest request) {
        return this.rawClient.rerank(request).thenApply(response -> (V2RerankResponse)response.body());
    }

    public CompletableFuture<V2RerankResponse> rerank(V2RerankRequest request, RequestOptions requestOptions) {
        return this.rawClient.rerank(request, requestOptions).thenApply(response -> (V2RerankResponse)response.body());
    }
}

