/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiException;
import com.cohere.api.core.CohereException;
import com.cohere.api.core.CohereHttpResponse;
import com.cohere.api.core.MediaTypes;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.ResponseBodyReader;
import com.cohere.api.core.Stream;
import com.cohere.api.errors.BadRequestError;
import com.cohere.api.errors.ClientClosedRequestError;
import com.cohere.api.errors.ForbiddenError;
import com.cohere.api.errors.GatewayTimeoutError;
import com.cohere.api.errors.InternalServerError;
import com.cohere.api.errors.InvalidTokenError;
import com.cohere.api.errors.NotFoundError;
import com.cohere.api.errors.NotImplementedError;
import com.cohere.api.errors.ServiceUnavailableError;
import com.cohere.api.errors.TooManyRequestsError;
import com.cohere.api.errors.UnauthorizedError;
import com.cohere.api.errors.UnprocessableEntityError;
import com.cohere.api.resources.v2.requests.V2ChatRequest;
import com.cohere.api.resources.v2.requests.V2ChatStreamRequest;
import com.cohere.api.resources.v2.requests.V2EmbedRequest;
import com.cohere.api.resources.v2.requests.V2RerankRequest;
import com.cohere.api.resources.v2.types.V2ChatResponse;
import com.cohere.api.resources.v2.types.V2ChatStreamResponse;
import com.cohere.api.resources.v2.types.V2RerankResponse;
import com.cohere.api.types.EmbedByTypeResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawV2Client {
    protected final ClientOptions clientOptions;

    public RawV2Client(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CohereHttpResponse<Iterable<V2ChatStreamResponse>> chatStream(V2ChatStreamRequest request) {
        return this.chatStream(request, null);
    }

    public CohereHttpResponse<Iterable<V2ChatStreamResponse>> chatStream(V2ChatStreamRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/chat").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try {
            Response response = client.newCall(okhttpRequest).execute();
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new CohereHttpResponse<Iterable<V2ChatStreamResponse>>(Stream.fromSse(V2ChatStreamResponse.class, new ResponseBodyReader(response)), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 422: {
                        throw new UnprocessableEntityError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 429: {
                        throw new TooManyRequestsError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 498: {
                        throw new InvalidTokenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 499: {
                        throw new ClientClosedRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 501: {
                        throw new NotImplementedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new CohereException("Network error executing HTTP request", e);
        }
    }

    public CohereHttpResponse<V2ChatResponse> chat(V2ChatRequest request) {
        return this.chat(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CohereHttpResponse<V2ChatResponse> chat(V2ChatRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/chat").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CohereHttpResponse<V2ChatResponse> cohereHttpResponse = new CohereHttpResponse<V2ChatResponse>((V2ChatResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), V2ChatResponse.class), response);
                return cohereHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 422: {
                        throw new UnprocessableEntityError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 429: {
                        throw new TooManyRequestsError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 498: {
                        throw new InvalidTokenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 499: {
                        throw new ClientClosedRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 501: {
                        throw new NotImplementedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new CohereException("Network error executing HTTP request", e);
        }
    }

    public CohereHttpResponse<EmbedByTypeResponse> embed(V2EmbedRequest request) {
        return this.embed(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CohereHttpResponse<EmbedByTypeResponse> embed(V2EmbedRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/embed").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CohereHttpResponse<EmbedByTypeResponse> cohereHttpResponse = new CohereHttpResponse<EmbedByTypeResponse>((EmbedByTypeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), EmbedByTypeResponse.class), response);
                return cohereHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 422: {
                        throw new UnprocessableEntityError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 429: {
                        throw new TooManyRequestsError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 498: {
                        throw new InvalidTokenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 499: {
                        throw new ClientClosedRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 501: {
                        throw new NotImplementedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new CohereException("Network error executing HTTP request", e);
        }
    }

    public CohereHttpResponse<V2RerankResponse> rerank(V2RerankRequest request) {
        return this.rerank(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CohereHttpResponse<V2RerankResponse> rerank(V2RerankRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/rerank").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CohereHttpResponse<V2RerankResponse> cohereHttpResponse = new CohereHttpResponse<V2RerankResponse>((V2RerankResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), V2RerankResponse.class), response);
                return cohereHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 422: {
                        throw new UnprocessableEntityError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 429: {
                        throw new TooManyRequestsError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 498: {
                        throw new InvalidTokenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 499: {
                        throw new ClientClosedRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 501: {
                        throw new NotImplementedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 503: {
                        throw new ServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 504: {
                        throw new GatewayTimeoutError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new CohereException("Network error executing HTTP request", e);
        }
    }
}

