/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.v2.RawV2Client;
import com.cohere.api.resources.v2.requests.V2ChatRequest;
import com.cohere.api.resources.v2.requests.V2ChatStreamRequest;
import com.cohere.api.resources.v2.requests.V2EmbedRequest;
import com.cohere.api.resources.v2.requests.V2RerankRequest;
import com.cohere.api.resources.v2.types.V2ChatResponse;
import com.cohere.api.resources.v2.types.V2ChatStreamResponse;
import com.cohere.api.resources.v2.types.V2RerankResponse;
import com.cohere.api.types.EmbedByTypeResponse;

public class V2Client {
    protected final ClientOptions clientOptions;
    private final RawV2Client rawClient;

    public V2Client(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawV2Client(clientOptions);
    }

    public RawV2Client withRawResponse() {
        return this.rawClient;
    }

    public Iterable<V2ChatStreamResponse> chatStream(V2ChatStreamRequest request) {
        return this.rawClient.chatStream(request).body();
    }

    public Iterable<V2ChatStreamResponse> chatStream(V2ChatStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.chatStream(request, requestOptions).body();
    }

    public V2ChatResponse chat(V2ChatRequest request) {
        return this.rawClient.chat(request).body();
    }

    public V2ChatResponse chat(V2ChatRequest request, RequestOptions requestOptions) {
        return this.rawClient.chat(request, requestOptions).body();
    }

    public EmbedByTypeResponse embed(V2EmbedRequest request) {
        return this.rawClient.embed(request).body();
    }

    public EmbedByTypeResponse embed(V2EmbedRequest request, RequestOptions requestOptions) {
        return this.rawClient.embed(request, requestOptions).body();
    }

    public V2RerankResponse rerank(V2RerankRequest request) {
        return this.rawClient.rerank(request).body();
    }

    public V2RerankResponse rerank(V2RerankRequest request, RequestOptions requestOptions) {
        return this.rawClient.rerank(request, requestOptions).body();
    }
}

