/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.v2.types.V2ChatStreamRequestDocumentsItem;
import com.cohere.api.resources.v2.types.V2ChatStreamRequestSafetyMode;
import com.cohere.api.resources.v2.types.V2ChatStreamRequestToolChoice;
import com.cohere.api.types.ChatMessageV2;
import com.cohere.api.types.CitationOptions;
import com.cohere.api.types.ResponseFormatV2;
import com.cohere.api.types.ToolV2;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V2ChatStreamRequest {
    private final String model;
    private final List<ChatMessageV2> messages;
    private final Optional<List<ToolV2>> tools;
    private final Optional<Boolean> strictTools;
    private final Optional<List<V2ChatStreamRequestDocumentsItem>> documents;
    private final Optional<CitationOptions> citationOptions;
    private final Optional<Boolean> rawPrompting;
    private final Optional<ResponseFormatV2> responseFormat;
    private final Optional<V2ChatStreamRequestSafetyMode> safetyMode;
    private final Optional<Integer> maxTokens;
    private final Optional<List<String>> stopSequences;
    private final Optional<Float> temperature;
    private final Optional<Integer> seed;
    private final Optional<Float> frequencyPenalty;
    private final Optional<Float> presencePenalty;
    private final Optional<Integer> k;
    private final Optional<Float> p;
    private final Optional<Boolean> logprobs;
    private final Optional<V2ChatStreamRequestToolChoice> toolChoice;
    private final Map<String, Object> additionalProperties;

    private V2ChatStreamRequest(String model, List<ChatMessageV2> messages, Optional<List<ToolV2>> tools, Optional<Boolean> strictTools, Optional<List<V2ChatStreamRequestDocumentsItem>> documents, Optional<CitationOptions> citationOptions, Optional<Boolean> rawPrompting, Optional<ResponseFormatV2> responseFormat, Optional<V2ChatStreamRequestSafetyMode> safetyMode, Optional<Integer> maxTokens, Optional<List<String>> stopSequences, Optional<Float> temperature, Optional<Integer> seed, Optional<Float> frequencyPenalty, Optional<Float> presencePenalty, Optional<Integer> k, Optional<Float> p, Optional<Boolean> logprobs, Optional<V2ChatStreamRequestToolChoice> toolChoice, Map<String, Object> additionalProperties) {
        this.model = model;
        this.messages = messages;
        this.tools = tools;
        this.strictTools = strictTools;
        this.documents = documents;
        this.citationOptions = citationOptions;
        this.rawPrompting = rawPrompting;
        this.responseFormat = responseFormat;
        this.safetyMode = safetyMode;
        this.maxTokens = maxTokens;
        this.stopSequences = stopSequences;
        this.temperature = temperature;
        this.seed = seed;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.k = k;
        this.p = p;
        this.logprobs = logprobs;
        this.toolChoice = toolChoice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="stream")
    public Boolean getStream() {
        return true;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="messages")
    public List<ChatMessageV2> getMessages() {
        return this.messages;
    }

    @JsonProperty(value="tools")
    public Optional<List<ToolV2>> getTools() {
        return this.tools;
    }

    @JsonProperty(value="strict_tools")
    public Optional<Boolean> getStrictTools() {
        return this.strictTools;
    }

    @JsonProperty(value="documents")
    public Optional<List<V2ChatStreamRequestDocumentsItem>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="citation_options")
    public Optional<CitationOptions> getCitationOptions() {
        return this.citationOptions;
    }

    @JsonProperty(value="raw_prompting")
    public Optional<Boolean> getRawPrompting() {
        return this.rawPrompting;
    }

    @JsonProperty(value="response_format")
    public Optional<ResponseFormatV2> getResponseFormat() {
        return this.responseFormat;
    }

    @JsonProperty(value="safety_mode")
    public Optional<V2ChatStreamRequestSafetyMode> getSafetyMode() {
        return this.safetyMode;
    }

    @JsonProperty(value="max_tokens")
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="stop_sequences")
    public Optional<List<String>> getStopSequences() {
        return this.stopSequences;
    }

    @JsonProperty(value="temperature")
    public Optional<Float> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="seed")
    public Optional<Integer> getSeed() {
        return this.seed;
    }

    @JsonProperty(value="frequency_penalty")
    public Optional<Float> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public Optional<Float> getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="k")
    public Optional<Integer> getK() {
        return this.k;
    }

    @JsonProperty(value="p")
    public Optional<Float> getP() {
        return this.p;
    }

    @JsonProperty(value="logprobs")
    public Optional<Boolean> getLogprobs() {
        return this.logprobs;
    }

    @JsonProperty(value="tool_choice")
    public Optional<V2ChatStreamRequestToolChoice> getToolChoice() {
        return this.toolChoice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2ChatStreamRequest && this.equalTo((V2ChatStreamRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2ChatStreamRequest other) {
        return this.model.equals(other.model) && this.messages.equals(other.messages) && this.tools.equals(other.tools) && this.strictTools.equals(other.strictTools) && this.documents.equals(other.documents) && this.citationOptions.equals(other.citationOptions) && this.rawPrompting.equals(other.rawPrompting) && this.responseFormat.equals(other.responseFormat) && this.safetyMode.equals(other.safetyMode) && this.maxTokens.equals(other.maxTokens) && this.stopSequences.equals(other.stopSequences) && this.temperature.equals(other.temperature) && this.seed.equals(other.seed) && this.frequencyPenalty.equals(other.frequencyPenalty) && this.presencePenalty.equals(other.presencePenalty) && this.k.equals(other.k) && this.p.equals(other.p) && this.logprobs.equals(other.logprobs) && this.toolChoice.equals(other.toolChoice);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.messages, this.tools, this.strictTools, this.documents, this.citationOptions, this.rawPrompting, this.responseFormat, this.safetyMode, this.maxTokens, this.stopSequences, this.temperature, this.seed, this.frequencyPenalty, this.presencePenalty, this.k, this.p, this.logprobs, this.toolChoice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    _FinalStage {
        private String model;
        private Optional<V2ChatStreamRequestToolChoice> toolChoice = Optional.empty();
        private Optional<Boolean> logprobs = Optional.empty();
        private Optional<Float> p = Optional.empty();
        private Optional<Integer> k = Optional.empty();
        private Optional<Float> presencePenalty = Optional.empty();
        private Optional<Float> frequencyPenalty = Optional.empty();
        private Optional<Integer> seed = Optional.empty();
        private Optional<Float> temperature = Optional.empty();
        private Optional<List<String>> stopSequences = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<V2ChatStreamRequestSafetyMode> safetyMode = Optional.empty();
        private Optional<ResponseFormatV2> responseFormat = Optional.empty();
        private Optional<Boolean> rawPrompting = Optional.empty();
        private Optional<CitationOptions> citationOptions = Optional.empty();
        private Optional<List<V2ChatStreamRequestDocumentsItem>> documents = Optional.empty();
        private Optional<Boolean> strictTools = Optional.empty();
        private Optional<List<ToolV2>> tools = Optional.empty();
        private List<ChatMessageV2> messages = new ArrayList<ChatMessageV2>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2ChatStreamRequest other) {
            this.model(other.getModel());
            this.messages(other.getMessages());
            this.tools(other.getTools());
            this.strictTools(other.getStrictTools());
            this.documents(other.getDocuments());
            this.citationOptions(other.getCitationOptions());
            this.rawPrompting(other.getRawPrompting());
            this.responseFormat(other.getResponseFormat());
            this.safetyMode(other.getSafetyMode());
            this.maxTokens(other.getMaxTokens());
            this.stopSequences(other.getStopSequences());
            this.temperature(other.getTemperature());
            this.seed(other.getSeed());
            this.frequencyPenalty(other.getFrequencyPenalty());
            this.presencePenalty(other.getPresencePenalty());
            this.k(other.getK());
            this.p(other.getP());
            this.logprobs(other.getLogprobs());
            this.toolChoice(other.getToolChoice());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(@NotNull String model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        public _FinalStage toolChoice(V2ChatStreamRequestToolChoice toolChoice) {
            this.toolChoice = Optional.ofNullable(toolChoice);
            return this;
        }

        @Override
        @JsonSetter(value="tool_choice", nulls=Nulls.SKIP)
        public _FinalStage toolChoice(Optional<V2ChatStreamRequestToolChoice> toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Override
        public _FinalStage logprobs(Boolean logprobs) {
            this.logprobs = Optional.ofNullable(logprobs);
            return this;
        }

        @Override
        @JsonSetter(value="logprobs", nulls=Nulls.SKIP)
        public _FinalStage logprobs(Optional<Boolean> logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @Override
        public _FinalStage p(Float p) {
            this.p = Optional.ofNullable(p);
            return this;
        }

        @Override
        @JsonSetter(value="p", nulls=Nulls.SKIP)
        public _FinalStage p(Optional<Float> p) {
            this.p = p;
            return this;
        }

        @Override
        public _FinalStage k(Integer k) {
            this.k = Optional.ofNullable(k);
            return this;
        }

        @Override
        @JsonSetter(value="k", nulls=Nulls.SKIP)
        public _FinalStage k(Optional<Integer> k) {
            this.k = k;
            return this;
        }

        @Override
        public _FinalStage presencePenalty(Float presencePenalty) {
            this.presencePenalty = Optional.ofNullable(presencePenalty);
            return this;
        }

        @Override
        @JsonSetter(value="presence_penalty", nulls=Nulls.SKIP)
        public _FinalStage presencePenalty(Optional<Float> presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Override
        public _FinalStage frequencyPenalty(Float frequencyPenalty) {
            this.frequencyPenalty = Optional.ofNullable(frequencyPenalty);
            return this;
        }

        @Override
        @JsonSetter(value="frequency_penalty", nulls=Nulls.SKIP)
        public _FinalStage frequencyPenalty(Optional<Float> frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Override
        public _FinalStage seed(Integer seed) {
            this.seed = Optional.ofNullable(seed);
            return this;
        }

        @Override
        @JsonSetter(value="seed", nulls=Nulls.SKIP)
        public _FinalStage seed(Optional<Integer> seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public _FinalStage temperature(Float temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Float> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage stopSequences(List<String> stopSequences) {
            this.stopSequences = Optional.ofNullable(stopSequences);
            return this;
        }

        @Override
        @JsonSetter(value="stop_sequences", nulls=Nulls.SKIP)
        public _FinalStage stopSequences(Optional<List<String>> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public _FinalStage maxTokens(Integer maxTokens) {
            this.maxTokens = Optional.ofNullable(maxTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxTokens(Optional<Integer> maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public _FinalStage safetyMode(V2ChatStreamRequestSafetyMode safetyMode) {
            this.safetyMode = Optional.ofNullable(safetyMode);
            return this;
        }

        @Override
        @JsonSetter(value="safety_mode", nulls=Nulls.SKIP)
        public _FinalStage safetyMode(Optional<V2ChatStreamRequestSafetyMode> safetyMode) {
            this.safetyMode = safetyMode;
            return this;
        }

        @Override
        public _FinalStage responseFormat(ResponseFormatV2 responseFormat) {
            this.responseFormat = Optional.ofNullable(responseFormat);
            return this;
        }

        @Override
        @JsonSetter(value="response_format", nulls=Nulls.SKIP)
        public _FinalStage responseFormat(Optional<ResponseFormatV2> responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Override
        public _FinalStage rawPrompting(Boolean rawPrompting) {
            this.rawPrompting = Optional.ofNullable(rawPrompting);
            return this;
        }

        @Override
        @JsonSetter(value="raw_prompting", nulls=Nulls.SKIP)
        public _FinalStage rawPrompting(Optional<Boolean> rawPrompting) {
            this.rawPrompting = rawPrompting;
            return this;
        }

        @Override
        public _FinalStage citationOptions(CitationOptions citationOptions) {
            this.citationOptions = Optional.ofNullable(citationOptions);
            return this;
        }

        @Override
        @JsonSetter(value="citation_options", nulls=Nulls.SKIP)
        public _FinalStage citationOptions(Optional<CitationOptions> citationOptions) {
            this.citationOptions = citationOptions;
            return this;
        }

        @Override
        public _FinalStage documents(List<V2ChatStreamRequestDocumentsItem> documents) {
            this.documents = Optional.ofNullable(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<V2ChatStreamRequestDocumentsItem>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage strictTools(Boolean strictTools) {
            this.strictTools = Optional.ofNullable(strictTools);
            return this;
        }

        @Override
        @JsonSetter(value="strict_tools", nulls=Nulls.SKIP)
        public _FinalStage strictTools(Optional<Boolean> strictTools) {
            this.strictTools = strictTools;
            return this;
        }

        @Override
        public _FinalStage tools(List<ToolV2> tools) {
            this.tools = Optional.ofNullable(tools);
            return this;
        }

        @Override
        @JsonSetter(value="tools", nulls=Nulls.SKIP)
        public _FinalStage tools(Optional<List<ToolV2>> tools) {
            this.tools = tools;
            return this;
        }

        @Override
        public _FinalStage addAllMessages(List<ChatMessageV2> messages) {
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public _FinalStage addMessages(ChatMessageV2 messages) {
            this.messages.add(messages);
            return this;
        }

        @Override
        @JsonSetter(value="messages", nulls=Nulls.SKIP)
        public _FinalStage messages(List<ChatMessageV2> messages) {
            this.messages.clear();
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public V2ChatStreamRequest build() {
            return new V2ChatStreamRequest(this.model, this.messages, this.tools, this.strictTools, this.documents, this.citationOptions, this.rawPrompting, this.responseFormat, this.safetyMode, this.maxTokens, this.stopSequences, this.temperature, this.seed, this.frequencyPenalty, this.presencePenalty, this.k, this.p, this.logprobs, this.toolChoice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2ChatStreamRequest build();

        public _FinalStage messages(List<ChatMessageV2> var1);

        public _FinalStage addMessages(ChatMessageV2 var1);

        public _FinalStage addAllMessages(List<ChatMessageV2> var1);

        public _FinalStage tools(Optional<List<ToolV2>> var1);

        public _FinalStage tools(List<ToolV2> var1);

        public _FinalStage strictTools(Optional<Boolean> var1);

        public _FinalStage strictTools(Boolean var1);

        public _FinalStage documents(Optional<List<V2ChatStreamRequestDocumentsItem>> var1);

        public _FinalStage documents(List<V2ChatStreamRequestDocumentsItem> var1);

        public _FinalStage citationOptions(Optional<CitationOptions> var1);

        public _FinalStage citationOptions(CitationOptions var1);

        public _FinalStage rawPrompting(Optional<Boolean> var1);

        public _FinalStage rawPrompting(Boolean var1);

        public _FinalStage responseFormat(Optional<ResponseFormatV2> var1);

        public _FinalStage responseFormat(ResponseFormatV2 var1);

        public _FinalStage safetyMode(Optional<V2ChatStreamRequestSafetyMode> var1);

        public _FinalStage safetyMode(V2ChatStreamRequestSafetyMode var1);

        public _FinalStage maxTokens(Optional<Integer> var1);

        public _FinalStage maxTokens(Integer var1);

        public _FinalStage stopSequences(Optional<List<String>> var1);

        public _FinalStage stopSequences(List<String> var1);

        public _FinalStage temperature(Optional<Float> var1);

        public _FinalStage temperature(Float var1);

        public _FinalStage seed(Optional<Integer> var1);

        public _FinalStage seed(Integer var1);

        public _FinalStage frequencyPenalty(Optional<Float> var1);

        public _FinalStage frequencyPenalty(Float var1);

        public _FinalStage presencePenalty(Optional<Float> var1);

        public _FinalStage presencePenalty(Float var1);

        public _FinalStage k(Optional<Integer> var1);

        public _FinalStage k(Integer var1);

        public _FinalStage p(Optional<Float> var1);

        public _FinalStage p(Float var1);

        public _FinalStage logprobs(Optional<Boolean> var1);

        public _FinalStage logprobs(Boolean var1);

        public _FinalStage toolChoice(Optional<V2ChatStreamRequestToolChoice> var1);

        public _FinalStage toolChoice(V2ChatStreamRequestToolChoice var1);
    }

    public static interface ModelStage {
        public _FinalStage model(@NotNull String var1);

        public Builder from(V2ChatStreamRequest var1);
    }
}

